/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import com.google.common.collect.ImmutableSet;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.core.client.model.VariableModel;
import org.cyclops.integrateddynamics.item.ItemVariable;

public class ItemVariableConfig
extends ItemConfig {
    public static ItemVariableConfig _instance;

    public ItemVariableConfig() {
        super((ModBase)IntegratedDynamics._instance, true, "variable", null, ItemVariable.class);
    }

    public boolean isDisableable() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    protected void validateModels() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        VariableModel.addAdditionalModels((ImmutableSet.Builder<ResourceLocation>)builder);
        ImmutableSet models = builder.build();
        for (ResourceLocation model : models) {
            if (ModelLoaderRegistry.loaded((ResourceLocation)model)) continue;
            throw new RuntimeException(String.format("Model file %s not found, it is required by the variable item model.", model));
        }
    }

    public void onInit(IInitListener.Step step) {
        super.onInit(step);
        if (step == IInitListener.Step.POSTINIT && MinecraftHelpers.isClientSide()) {
            this.validateModels();
        }
    }
}

