/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.modcompat.charset.aspect;

import java.util.Collections;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.part.aspect.build.AspectBuilder;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectValuePropagator;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectWriteActivator;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectWriteDeactivator;
import org.cyclops.integrateddynamics.modcompat.charset.CharsetPipesModCompat;
import org.cyclops.integrateddynamics.modcompat.charset.aspect.ShifterPart;
import org.cyclops.integrateddynamics.part.aspect.read.AspectReadBuilders;
import org.cyclops.integrateddynamics.part.aspect.write.AspectWriteBuilders;
import pl.asie.charset.api.pipes.IPipe;

public class CharsetAspects {

    public static final class Write {

        public static final class Pipe {
            public static final IAspectWriteActivator ACTIVATOR = new IAspectWriteActivator(){

                @Override
                public <P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>> void onActivate(P partType, PartTarget target, S state) {
                    state.addVolatileCapability(CharsetPipesModCompat.SHIFTER, (ShifterPart)new ShifterPart(target.getCenter().getSide()));
                    Pipe.notifyNeighbours(target);
                }
            };
            public static final IAspectWriteDeactivator DEACTIVATOR = new IAspectWriteDeactivator(){

                @Override
                public <P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>> void onDeactivate(P partType, PartTarget target, S state) {
                    state.removeVolatileCapability(CharsetPipesModCompat.SHIFTER);
                    Pipe.notifyNeighbours(target);
                }
            };
            public static final IAspectWrite<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean> SHIFTER_BOOLEAN = Pipe.getShifter(AspectWriteBuilders.BUILDER_BOOLEAN.appendKind("charsetpipe").appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("shifter")).handle(new IAspectValuePropagator<Pair<ShifterPart, ValueTypeBoolean.ValueBoolean>, Void>(){

                @Override
                public Void getOutput(Pair<ShifterPart, ValueTypeBoolean.ValueBoolean> input) throws EvaluationException {
                    ShifterPart shifter = (ShifterPart)input.getLeft();
                    shifter.setShifting(((ValueTypeBoolean.ValueBoolean)input.getRight()).getRawValue());
                    return null;
                }
            }).buildWrite();
            public static final IAspectWrite<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack> SHIFTER_ITEMSTACK = Pipe.getShifter(AspectWriteBuilders.BUILDER_ITEMSTACK.appendKind("charsetpipe").appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("shifter")).handle(new IAspectValuePropagator<Pair<ShifterPart, ValueObjectTypeItemStack.ValueItemStack>, Void>(){

                @Override
                public Void getOutput(Pair<ShifterPart, ValueObjectTypeItemStack.ValueItemStack> input) throws EvaluationException {
                    ShifterPart shifter = (ShifterPart)input.getLeft();
                    shifter.setFilter(Collections.singleton(input.getRight()));
                    shifter.setShifting(true);
                    return null;
                }
            }).buildWrite();
            public static final IAspectWrite<ValueTypeList.ValueList, ValueTypeList> SHIFTER_LIST = Pipe.getShifter(AspectWriteBuilders.BUILDER_LIST.appendKind("charsetpipe").appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("shifter")).handle(new IAspectValuePropagator<Pair<ShifterPart, ValueTypeList.ValueList>, Void>(){

                @Override
                public Void getOutput(Pair<ShifterPart, ValueTypeList.ValueList> input) throws EvaluationException {
                    ShifterPart shifter = (ShifterPart)input.getLeft();
                    if (((ValueTypeList.ValueList)input.getRight()).getRawValue().getValueType() != ValueTypes.OBJECT_ITEMSTACK) {
                        throw new EvaluationException(new L10NHelpers.UnlocalizedString("aspect.integrateddynamics.error.invalidType", new Object[]{new L10NHelpers.UnlocalizedString(ValueTypes.OBJECT_ITEMSTACK.getUnlocalizedName(), new Object[0]), new L10NHelpers.UnlocalizedString(((ValueTypeList.ValueList)input.getRight()).getRawValue().getValueType().getUnlocalizedName(), new Object[0])}).localize());
                    }
                    shifter.setFilter(((ValueTypeList.ValueList)input.getRight()).getRawValue());
                    shifter.setShifting(true);
                    return null;
                }
            }).buildWrite();

            public static <V extends IValue, T extends IValueType<V>, O> AspectBuilder<V, T, Pair<ShifterPart, O>> getShifter(AspectBuilder<V, T, Triple<PartTarget, IAspectProperties, O>> builder) {
                return builder.handle(new IAspectValuePropagator<Triple<PartTarget, IAspectProperties, O>, Pair<ShifterPart, O>>(){

                    @Override
                    public Pair<ShifterPart, O> getOutput(Triple<PartTarget, IAspectProperties, O> input) throws EvaluationException {
                        PartPos center = ((PartTarget)input.getLeft()).getCenter();
                        return Pair.of((Object)((ShifterPart)TileHelpers.getCapability((World)center.getPos().getWorld(), (BlockPos)center.getPos().getBlockPos(), (EnumFacing)center.getSide(), CharsetPipesModCompat.SHIFTER)), (Object)input.getRight());
                    }
                });
            }

            protected static void notifyNeighbours(PartTarget target) {
                DimPos dimPos = target.getCenter().getPos();
                dimPos.getWorld().func_175685_c(dimPos.getBlockPos(), dimPos.getWorld().func_180495_p(dimPos.getBlockPos()).func_177230_c());
            }
        }
    }

    public static final class Read {

        public static final class Pipe {
            public static final IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, IPipe> PROP_GET = new IAspectValuePropagator<Pair<PartTarget, IAspectProperties>, IPipe>(){

                @Override
                public IPipe getOutput(Pair<PartTarget, IAspectProperties> input) {
                    DimPos pos = ((PartTarget)input.getLeft()).getTarget().getPos();
                    return CableHelpers.getInterface(pos, IPipe.class);
                }
            };
            public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, IPipe> BUILDER_BOOLEAN = AspectReadBuilders.BUILDER_BOOLEAN.handle(PROP_GET, "charsetpipe");
            public static final AspectBuilder<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack, IPipe> BUILDER_OBJECT_ITEMSTACK = AspectReadBuilders.BUILDER_OBJECT_ITEMSTACK.handle(PROP_GET, "charsetpipe");
            public static final IAspectRead<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean> BOOLEAN_ISAPPLICABLE = BUILDER_BOOLEAN.handle(new IAspectValuePropagator<IPipe, Boolean>(){

                @Override
                public Boolean getOutput(IPipe pipe) {
                    return pipe != null;
                }
            }).handle(AspectReadBuilders.PROP_GET_BOOLEAN, "applicable").buildRead();
            public static final IAspectRead<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean> BOOLEAN_HASCONTENTS = BUILDER_BOOLEAN.handle(new IAspectValuePropagator<IPipe, Boolean>(){

                @Override
                public Boolean getOutput(IPipe pipe) {
                    if (pipe != null) {
                        return pipe.getTravellingStack(null) != null;
                    }
                    return false;
                }
            }).handle(AspectReadBuilders.PROP_GET_BOOLEAN, "hascontents").buildRead();
            public static final IAspectRead<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack> ITEMSTACK_CONTENTS = BUILDER_OBJECT_ITEMSTACK.handle(new IAspectValuePropagator<IPipe, ItemStack>(){

                @Override
                public ItemStack getOutput(IPipe pipe) {
                    if (pipe != null) {
                        return pipe.getTravellingStack(null);
                    }
                    return null;
                }
            }).handle(AspectReadBuilders.PROP_GET_ITEMSTACK, "contents").buildRead();
        }
    }
}

