/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.modcompat.mcmultipart;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IPartConverter;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.core.block.cable.CableNetworkComponent;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.tileentity.TileMultipartTicking;
import org.cyclops.integrateddynamics.item.ItemFacade;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.PartCable;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.PartPartType;

public class BlockCableConverter
implements IPartConverter.IPartConverter2 {
    public Collection<Block> getConvertableBlocks() {
        return Collections.singleton(BlockCable.getInstance());
    }

    public Collection<? extends IMultipart> convertBlock(IBlockAccess world, BlockPos blockPos, boolean simulate) {
        LinkedList parts = Lists.newLinkedList();
        TileMultipartTicking tile = (TileMultipartTicking)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)blockPos, TileMultipartTicking.class);
        HashMap partData = Maps.newHashMap(tile.getPartData());
        HashMap forceDisconnected = Maps.newHashMap(tile.getForceDisconnected());
        for (Map.Entry entry : partData.entrySet()) {
            parts.add(new PartPartType((EnumFacing)entry.getKey(), ((PartHelpers.PartStateHolder)entry.getValue()).getPart()));
        }
        boolean wasRealCable = tile.isRealCable();
        IPartNetwork network = null;
        if (!simulate) {
            tile.silentResetPartData();
            network = tile.getNetwork();
            tile.resetCurrentNetwork();
            tile.setRealCable(false);
            BlockCable.IS_MCMP_CONVERTING = true;
        }
        if (wasRealCable) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                boolean cableConnected = (!forceDisconnected.containsKey(side.ordinal()) || (Boolean)forceDisconnected.get(side.ordinal()) == false) && CableNetworkComponent.canSideConnect((World)world, blockPos, side, (ICable)tile.getBlock());
                ICable neighbourCable = CableHelpers.getInterface(world, blockPos.func_177972_a(side), ICable.class);
                if (neighbourCable == null) continue;
                forceDisconnected.put(side.ordinal(), !cableConnected);
            }
            PartCable partCable = new PartCable(partData, forceDisconnected);
            if (!simulate) {
                partCable.setNetwork(network);
            }
            partCable.setAddSilent(true);
            parts.add(partCable);
        }
        if (!simulate && tile.hasFacade()) {
            IBlockState blockState = tile.getFacade();
            ItemStack itemStack = new ItemStack((Item)ItemFacade.getInstance());
            ItemFacade.getInstance().writeFacadeBlock(itemStack, blockState);
            ItemStackHelpers.spawnItemStack((World)tile.func_145831_w(), (BlockPos)blockPos, (ItemStack)itemStack);
        }
        return parts;
    }
}

