/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.modcompat.mcmultipart;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.IPartConverter;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.tileentity.TileMultipartTicking;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.PartCable;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.PartPartType;

public class BlockCableReverseConverter
implements IPartConverter.IReversePartConverter {
    public boolean convertToBlock(IMultipartContainer multipartContainer) {
        Collection parts = multipartContainer.getParts();
        for (IMultipart part : parts) {
            if (part instanceof PartCable || part instanceof PartPartType) continue;
            return false;
        }
        if (parts.size() > 0) {
            HashMap partData = null;
            Map<Integer, Boolean> forceDisconnected = null;
            boolean hasParts = false;
            IPartNetwork network = null;
            for (IMultipart part : parts) {
                if (part instanceof PartCable) {
                    partData = ((PartCable)part).getPartData();
                    forceDisconnected = ((PartCable)part).getForceDisconnected();
                    ((PartCable)part).setSendFurtherUpdates(false);
                    network = ((PartCable)part).getNetwork();
                    continue;
                }
                if (!(part instanceof PartPartType)) continue;
                hasParts = true;
            }
            World world = multipartContainer.getWorldIn();
            BlockPos pos = multipartContainer.getPosIn();
            world.func_175656_a(pos, BlockCable.getInstance().func_176223_P());
            TileMultipartTicking tile = (TileMultipartTicking)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileMultipartTicking.class);
            if (partData == null) {
                tile.setRealCable(false);
                partData = Maps.newHashMap();
                if (hasParts) {
                    for (IMultipart part : parts) {
                        if (!(part instanceof PartPartType)) continue;
                        PartPartType partPart = (PartPartType)part;
                        partData.put(partPart.getFacing(), PartHelpers.PartStateHolder.of(partPart.getPartType(), partPart.getPartType().getDefaultState()));
                    }
                }
            }
            tile.setNetwork(network);
            tile.setPartData(partData);
            tile.setForceDisconnected(forceDisconnected);
            tile.sendImmediateUpdate();
            return true;
        }
        return false;
    }
}

