/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.modcompat.mcmultipart;

import mcmultipart.client.multipart.MultipartRegistryClient;
import mcmultipart.client.multipart.MultipartSpecialRenderer;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.IPartConverter;
import mcmultipart.multipart.IPartFactory;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.multipart.MultipartRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.client.render.part.IPartOverlayRenderer;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.block.BlockCableConfig;
import org.cyclops.integrateddynamics.client.render.part.PartOverlayRenderers;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.item.ItemPart;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.item.ItemBlockCable;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.BlockCableConverter;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.BlockCableReverseConverter;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.McMultiPartEventListener;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.PartCable;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.PartPartType;

public class McMultiPartHelpers {
    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation CABLE_MODEL_LOCATION;

    public static void load() {
        MultipartRegistry.registerPart(PartCable.class, (String)"integrateddynamics:cable");
        for (final IPartType partType : PartTypes.REGISTRY.getPartTypes()) {
            MultipartRegistry.registerPartFactory((IPartFactory)new IPartFactory(){

                public IMultipart createPart(String s, boolean b) {
                    PartPartType partPart = new PartPartType();
                    partPart.init(EnumFacing.NORTH, partType);
                    return partPart;
                }
            }, (String[])new String[]{PartPartType.getType(partType)});
        }
        CableHelpers.addInterfaceRetriever(new CableHelpers.IInterfaceRetriever(){

            @Override
            public <C> C getInterface(IBlockAccess world, BlockPos pos, Class<C> clazz) {
                IMultipartContainer multipartContainer = (IMultipartContainer)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, IMultipartContainer.class);
                if (multipartContainer != null) {
                    for (IMultipart part : multipartContainer.getParts()) {
                        if (!clazz.isInstance(part)) continue;
                        return clazz.cast(part);
                    }
                }
                return null;
            }
        });
        ItemBlockCable.addUseAction(new ItemBlockCable.IUseAction(){

            @Override
            public boolean attempItemUseTarget(ItemStack itemStack, World world, BlockPos pos, BlockCable blockCable) {
                PartCable partCable = new PartCable();
                if (MultipartHelper.canAddPart((World)world, (BlockPos)pos, (IMultipart)partCable)) {
                    if (!world.field_72995_K) {
                        MultipartHelper.addPart((World)world, (BlockPos)pos, (IMultipart)partCable);
                    }
                    return true;
                }
                return false;
            }
        });
        ItemPart.addUseAction(new ItemPart.IUseAction(){

            @Override
            public boolean attempItemUseTarget(ItemPart itemPart, ItemStack itemStack, World world, BlockPos pos, EnumFacing sideHit) {
                PartPartType partPart = new PartPartType(sideHit.func_176734_d(), itemPart.getPart());
                if (MultipartHelper.getPartContainer((IBlockAccess)world, (BlockPos)(pos = pos.func_177972_a(sideHit))) != null && MultipartHelper.canAddPart((World)world, (BlockPos)pos, (IMultipart)partPart)) {
                    if (!world.field_72995_K) {
                        MultipartHelper.addPart((World)world, (BlockPos)pos, (IMultipart)partPart);
                    }
                    return true;
                }
                return false;
            }
        });
        MultipartRegistry.registerPartConverter((IPartConverter.IPartConverter2)new BlockCableConverter());
        MultipartRegistry.registerReversePartConverter((IPartConverter.IReversePartConverter)new BlockCableReverseConverter());
    }

    protected static String getModelPathCable() {
        return "integrateddynamics:" + BlockCableConfig._instance.getNamedId();
    }

    @SideOnly(value=Side.CLIENT)
    public static void loadClient() {
        MinecraftForge.EVENT_BUS.register((Object)new McMultiPartEventListener());
        final ModelResourceLocation blockLocation = new ModelResourceLocation(McMultiPartHelpers.getModelPathCable(), "multipart");
        ModelLoader.setCustomStateMapper((Block)BlockCable.getInstance(), (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState blockState) {
                return blockLocation;
            }
        });
        CABLE_MODEL_LOCATION = blockLocation;
        MultipartRegistryClient.bindMultipartSpecialRenderer(PartPartType.class, (MultipartSpecialRenderer)new MultipartSpecialRenderer<PartPartType>(){

            public void renderMultipartAt(PartPartType partPartType, double x, double y, double z, float partialTick, int destroyStage) {
                IPartContainer partContainer = partPartType.getPartContainer();
                if (partContainer != null) {
                    for (IPartOverlayRenderer renderer : PartOverlayRenderers.REGISTRY.getRenderers(partPartType.getPartType())) {
                        renderer.renderPartOverlay(partContainer, x, y, z, partialTick, destroyStage, partPartType.getFacing(), partPartType.getPartType(), this.rendererDispatcher);
                    }
                }
            }
        });
    }
}

