/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.modcompat.thaumcraft;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.modcompat.IModCompat;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.client.render.valuetype.ValueTypeWorldRenderers;
import org.cyclops.integrateddynamics.core.evaluate.IOperatorValuePropagator;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyFactories;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNBTFactory;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.modcompat.thaumcraft.aspect.read.ThaumcraftAspects;
import org.cyclops.integrateddynamics.modcompat.thaumcraft.client.render.valuetype.AspectValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.modcompat.thaumcraft.evaluate.operator.OperatorBuilders;
import org.cyclops.integrateddynamics.modcompat.thaumcraft.evaluate.variable.ValueObjectTypeAspect;
import org.cyclops.integrateddynamics.modcompat.thaumcraft.evaluate.variable.ValueTypeListProxyPositionedAspectContainer;
import org.cyclops.integrateddynamics.modcompat.thaumcraft.logicprogrammer.ValueObjectTypeAspectElementType;
import org.cyclops.integrateddynamics.part.aspect.Aspects;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;

public class ThaumcraftModCompat
implements IModCompat {
    public static ValueObjectTypeAspect OBJECT_ASPECT;
    public static ValueTypeListProxyNBTFactory<ValueObjectTypeAspect, ValueObjectTypeAspect.ValueAspect, ValueTypeListProxyPositionedAspectContainer> POSITIONED_ASPECTCONTAINER;
    public static ValueObjectTypeAspectElementType OBJECT_ASPECT_ELEMENTTYPE;

    public String getModID() {
        return "Thaumcraft";
    }

    public void onInit(IInitListener.Step step) {
        if (step == IInitListener.Step.PREINIT) {
            OBJECT_ASPECT = ValueTypes.REGISTRY.register(new ValueObjectTypeAspect());
            Aspects.REGISTRY.register((IPartType)PartTypes.MACHINE_READER, Sets.newHashSet((Object[])new IAspect[]{ThaumcraftAspects.Read.Aspect.BOOLEAN_ISASPECTCONTAINER, ThaumcraftAspects.Read.Aspect.LIST_ASPECTCONTAINER, ThaumcraftAspects.Read.Aspect.ASPECT}));
            POSITIONED_ASPECTCONTAINER = ValueTypeListProxyFactories.REGISTRY.register(new ValueTypeListProxyNBTFactory("positionedAspectContainer", ValueTypeListProxyPositionedAspectContainer.class));
            OBJECT_ASPECT_ELEMENTTYPE = LogicProgrammerElementTypes.REGISTRY.addType(new ValueObjectTypeAspectElementType());
            Operators.REGISTRY.register(org.cyclops.integrateddynamics.core.evaluate.OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.output(ValueTypes.LIST).symbol("aspects").operatorName("getitemthaumcraftaspects").function(new OperatorBase.IFunction(){

                @Override
                public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
                    Optional a = ((ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0)).getRawValue();
                    if (a.isPresent()) {
                        AspectList aspectList = AspectHelper.getObjectAspects((ItemStack)((ItemStack)a.get()));
                        Aspect[] aspectArray = aspectList.getAspectsSortedByAmount();
                        ArrayList list = Lists.newArrayListWithExpectedSize((int)aspectArray.length);
                        for (Aspect aspect : aspectArray) {
                            list.add(ValueObjectTypeAspect.ValueAspect.of(aspect, aspectList.getAmount(aspect)));
                        }
                        return ValueTypeList.ValueList.ofList(OBJECT_ASPECT, list);
                    }
                    return ValueTypeList.ValueList.ofList(OBJECT_ASPECT, Collections.emptyList());
                }
            }).build());
            Operators.REGISTRY.register(OperatorBuilders.ASPECT_1_SUFFIX_LONG.output(ValueTypes.INTEGER).symbolOperator("amount").function(OperatorBuilders.FUNCTION_ASPECT_TO_INT.build(new IOperatorValuePropagator<Pair<Aspect, Integer>, Integer>(){

                @Override
                public Integer getOutput(Pair<Aspect, Integer> input) throws EvaluationException {
                    return input != null ? (Integer)input.getRight() : 0;
                }
            })).build());
            Operators.REGISTRY.register(OperatorBuilders.ASPECT_2.output(ValueTypes.BOOLEAN).symbol("=Aspect=").operatorName("israwaspectequal").function(new OperatorBase.IFunction(){

                @Override
                public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
                    Optional a = ((ValueObjectTypeAspect.ValueAspect)variables.getValue(0)).getRawValue();
                    Optional b = ((ValueObjectTypeAspect.ValueAspect)variables.getValue(1)).getRawValue();
                    boolean equal = false;
                    if (a.isPresent() && b.isPresent()) {
                        equal = ((Aspect)((Pair)a.get()).getKey()).equals(((Pair)b.get()).getKey());
                    } else if (!a.isPresent() && !b.isPresent()) {
                        equal = true;
                    }
                    return ValueTypeBoolean.ValueBoolean.of(equal);
                }
            }).build());
            Operators.REGISTRY.register(OperatorBuilders.ASPECT_1_SUFFIX_LONG.output(ValueTypes.LIST).symbol("compound aspects").operatorName("getcompoundaspects").function(new OperatorBase.IFunction(){

                @Override
                public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
                    Optional a = ((ValueObjectTypeAspect.ValueAspect)variables.getValue(0)).getRawValue();
                    if (a.isPresent()) {
                        Aspect[] aspectArray = ((Aspect)((Pair)a.get()).getKey()).getComponents();
                        ArrayList list = Lists.newArrayListWithExpectedSize((int)aspectArray.length);
                        for (Aspect aspect : aspectArray) {
                            list.add(ValueObjectTypeAspect.ValueAspect.of(aspect, 1));
                        }
                        return ValueTypeList.ValueList.ofList(OBJECT_ASPECT, list);
                    }
                    return ValueTypeList.ValueList.ofList(OBJECT_ASPECT, Collections.emptyList());
                }
            }).build());
            Operators.REGISTRY.register(OperatorBuilders.ASPECT_1_SUFFIX_LONG.output(ValueTypes.BOOLEAN).symbolOperator("isprimal").function(OperatorBuilders.FUNCTION_ASPECT_TO_BOOLEAN.build(new IOperatorValuePropagator<Pair<Aspect, Integer>, Boolean>(){

                @Override
                public Boolean getOutput(Pair<Aspect, Integer> input) throws EvaluationException {
                    return input != null && ((Aspect)input.getLeft()).isPrimal();
                }
            })).build());
            if (MinecraftHelpers.isClientSide()) {
                this.initClient();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void initClient() {
        ValueTypeWorldRenderers.REGISTRY.register(OBJECT_ASPECT, new AspectValueTypeWorldRenderer());
    }

    public boolean isEnabled() {
        return true;
    }

    public String getComment() {
        return "Thaumcraft reader.";
    }
}

