/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.part.aspect;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.client.gui.ExtendedGuiHandler;
import org.cyclops.integrateddynamics.core.client.gui.container.GuiAspectSettings;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerAspectSettings;

public abstract class AspectBase<V extends IValue, T extends IValueType<V>>
implements IAspect<V, T> {
    private final IAspectProperties defaultProperties;
    private final IGuiContainerProvider propertiesGuiProvider;

    @Deprecated
    public AspectBase() {
        this(null);
    }

    public AspectBase(IAspectProperties defaultProperties) {
        IAspectProperties iAspectProperties = this.defaultProperties = defaultProperties == null ? this.createDefaultProperties() : defaultProperties;
        if (this.hasProperties()) {
            int guiIDSettings = Helpers.getNewId((ModBase)this.getMod(), (Helpers.IDType)Helpers.IDType.GUI);
            this.propertiesGuiProvider = this.constructSettingsGuiProvider(guiIDSettings);
            this.getMod().getGuiHandler().registerGUI(this.propertiesGuiProvider, ExtendedGuiHandler.ASPECT);
        } else {
            this.propertiesGuiProvider = null;
        }
    }

    protected IGuiContainerProvider constructSettingsGuiProvider(int guiId) {
        return new GuiProviderSettings(guiId, this.getMod());
    }

    @Override
    public String getUnlocalizedName() {
        return this.getUnlocalizedPrefix() + ".name";
    }

    protected String getUnlocalizedPrefix() {
        return "aspect.aspects." + this.getModId() + "." + this.getUnlocalizedType();
    }

    protected abstract String getUnlocalizedType();

    @Override
    public void loadTooltip(List<String> lines, boolean appendOptionalInfo) {
        String aspectName = L10NHelpers.localize((String)this.getUnlocalizedName());
        String valueTypeName = L10NHelpers.localize((String)this.getValueType().getUnlocalizedName());
        lines.add(L10NHelpers.localize((String)"aspect.integrateddynamics.tooltip.aspectName", (Object[])new Object[]{aspectName}));
        lines.add(L10NHelpers.localize((String)"aspect.integrateddynamics.tooltip.valueTypeName", (Object[])new Object[]{this.getValueType().getDisplayColorFormat() + valueTypeName}));
        if (appendOptionalInfo) {
            L10NHelpers.addOptionalInfo(lines, (String)this.getUnlocalizedPrefix());
        }
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> boolean hasProperties() {
        return this.getDefaultProperties() != null;
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> IAspectProperties getProperties(P partType, PartTarget target, S state) {
        IAspectProperties properties = state.getAspectProperties(this);
        if (properties == null) {
            properties = this.getDefaultProperties().clone();
        }
        this.setProperties(partType, target, state, properties);
        return properties;
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> void setProperties(P partType, PartTarget target, S state, IAspectProperties properties) {
        state.setAspectProperties(this, properties);
    }

    @Override
    public final IAspectProperties getDefaultProperties() {
        return this.defaultProperties;
    }

    @Override
    public Collection<IAspectPropertyTypeInstance> getPropertyTypes() {
        return this.getDefaultProperties().getTypes();
    }

    @Deprecated
    protected IAspectProperties createDefaultProperties() {
        return null;
    }

    protected ModBase getMod() {
        return IntegratedDynamics._instance;
    }

    protected String getModId() {
        return this.getMod().getModId();
    }

    @Override
    public IGuiContainerProvider getPropertiesGuiProvider() {
        return this.propertiesGuiProvider;
    }

    public static class GuiProviderSettings
    implements IGuiContainerProvider {
        private final int guiID;
        private final ModBase mod;

        public Class<? extends Container> getContainer() {
            return ContainerAspectSettings.class;
        }

        @SideOnly(value=Side.CLIENT)
        public Class<? extends GuiScreen> getGui() {
            return GuiAspectSettings.class;
        }

        @ConstructorProperties(value={"guiID", "mod"})
        public GuiProviderSettings(int guiID, ModBase mod) {
            this.guiID = guiID;
            this.mod = mod;
        }

        public int getGuiID() {
            return this.guiID;
        }

        public ModBase getMod() {
            return this.mod;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GuiProviderSettings)) {
                return false;
            }
            GuiProviderSettings other = (GuiProviderSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getGuiID() != other.getGuiID()) {
                return false;
            }
            ModBase this$mod = this.getMod();
            ModBase other$mod = other.getMod();
            return !(this$mod == null ? other$mod != null : !this$mod.equals(other$mod));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GuiProviderSettings;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getGuiID();
            ModBase $mod = this.getMod();
            result = result * 59 + ($mod == null ? 0 : $mod.hashCode());
            return result;
        }

        public String toString() {
            return "AspectBase.GuiProviderSettings(guiID=" + this.getGuiID() + ", mod=" + this.getMod() + ")";
        }
    }
}

