/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import cofh.api.energy.IEnergyConnection;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.block.BlockCoalGenerator;
import org.cyclops.integrateddynamics.core.tileentity.TileCableConnectableInventory;
import org.cyclops.integrateddynamics.modcompat.rf.RfHelpers;

@Optional.Interface(iface="cofh.api.energy.IEnergyConnection", modid="CoFHAPI", striprefs=true)
public class TileCoalGenerator
extends TileCableConnectableInventory
implements IEnergyConnection {
    public static final int MAX_PROGRESS = 13;
    public static final int ENERGY_PER_TICK = 20;
    public static final int SLOT_FUEL = 0;
    @NBTPersist
    private int currentlyBurningMax;
    @NBTPersist
    private int currentlyBurning;

    public TileCoalGenerator() {
        super(1, "fuel", 64);
    }

    @Override
    public IEnergyNetwork getNetwork() {
        return (IEnergyNetwork)super.getNetwork();
    }

    public void updateBlockState() {
        this.func_145831_w().func_175656_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockCoalGenerator.ON, (Comparable)Boolean.valueOf(this.isBurning())));
    }

    public int getProgress() {
        float current = this.currentlyBurning;
        float max = this.currentlyBurningMax;
        return Math.round(current / max * 13.0f);
    }

    public boolean isBurning() {
        return this.currentlyBurning < this.currentlyBurningMax;
    }

    protected boolean isRf() {
        return RfHelpers.isRf();
    }

    public boolean canAddEnergy(int energy) {
        IEnergyNetwork network = this.getNetwork();
        if (network != null && network.addEnergy(energy, true) == energy) {
            return true;
        }
        return this.isRf() && this.addEnergyRf(energy, true) == energy;
    }

    protected int addEnergy(int energy) {
        IEnergyNetwork network = this.getNetwork();
        int toFill = energy;
        if (network != null) {
            toFill -= network.addEnergy(toFill, false);
        }
        if (toFill > 0 && this.isRf()) {
            toFill -= this.addEnergyRf(toFill, false);
        }
        return energy - toFill;
    }

    @Override
    protected void updateTileEntity() {
        super.updateTileEntity();
        if ((this.func_70301_a(0) != null || this.isBurning()) && this.canAddEnergy(20)) {
            ItemStack fuel;
            if (this.isBurning()) {
                if (this.currentlyBurning++ >= this.currentlyBurningMax) {
                    this.currentlyBurning = 0;
                    this.currentlyBurningMax = 0;
                    this.sendUpdate();
                }
                int toFill = 20;
                this.addEnergy(toFill);
                this.func_70296_d();
            }
            if (!this.isBurning() && (fuel = this.func_70298_a(0, 1)) != null && TileEntityFurnace.func_145954_b((ItemStack)fuel)) {
                if (this.func_70301_a(0) == null) {
                    this.func_70299_a(0, fuel.func_77973_b().getContainerItem(fuel));
                }
                this.currentlyBurningMax = TileEntityFurnace.func_145952_a((ItemStack)fuel);
                this.currentlyBurning = 0;
                this.sendUpdate();
                this.updateBlockState();
            }
        }
    }

    protected int addEnergyRf(int energy, boolean simulate) {
        return RfHelpers.fillNeigbours(this.func_145831_w(), this.func_174877_v(), energy, simulate);
    }

    @Optional.Method(modid="CoFHAPI")
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }
}

