/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import com.google.common.collect.Sets;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IValueTypeVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.item.ValueTypeVariableFacade;
import org.cyclops.integrateddynamics.core.tileentity.TileActiveVariableBase;
import org.cyclops.integrateddynamics.network.MaterializerNetworkElement;

public class TileMaterializer
extends TileActiveVariableBase<MaterializerNetworkElement> {
    public static final int SLOT_READ = 0;
    public static final int SLOT_WRITE_IN = 1;
    public static final int SLOT_WRITE_OUT = 2;

    public TileMaterializer() {
        super(3, "materializer");
        this.addSlotsToSide(EnumFacing.UP, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.DOWN, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.SOUTH, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.WEST, Sets.newHashSet((Object[])new Integer[]{2}));
        this.addSlotsToSide(EnumFacing.EAST, Sets.newHashSet((Object[])new Integer[]{1}));
    }

    public boolean func_180462_a(int slot, ItemStack itemStack, EnumFacing side) {
        return slot != 2 && super.func_180462_a(slot, itemStack, side);
    }

    @Override
    public int getSlotRead() {
        return 0;
    }

    protected boolean canWrite() {
        return this.getNetwork() != null && this.getVariable(this.getNetwork()) != null && this.getErrors().isEmpty();
    }

    @Override
    public void onDirty() {
        ItemStack outputStack;
        super.onDirty();
        if (!this.field_145850_b.field_72995_K && this.func_70301_a(1) != null && this.canWrite() && this.func_70301_a(2) == null && (outputStack = this.writeMaterialized(!this.func_145831_w().field_72995_K, this.func_70301_a(1))) != null) {
            this.func_70299_a(2, outputStack);
            this.func_70304_b(1);
        }
    }

    public ItemStack writeMaterialized(boolean generateId, ItemStack itemStack) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        IVariable<?> variable = this.getVariable(this.getNetwork());
        try {
            final IValueType<?> valueType = variable.getType();
            final Object value = variable.getType().materialize(variable.getValue());
            return registry.writeVariableFacadeItem(generateId, itemStack, ValueTypes.REGISTRY, new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IValueTypeVariableFacade>(){

                @Override
                public IValueTypeVariableFacade create(boolean generateId) {
                    return new ValueTypeVariableFacade<IValue>(generateId, valueType, value);
                }

                @Override
                public IValueTypeVariableFacade create(int id) {
                    return new ValueTypeVariableFacade<IValue>(id, valueType, value);
                }
            });
        }
        catch (EvaluationException e) {
            this.addError(new L10NHelpers.UnlocalizedString(e.getMessage(), new Object[0]));
            return null;
        }
    }
}

