/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import com.google.common.collect.Sets;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeRegistry;
import org.cyclops.cyclopscore.recipe.custom.component.DummyPropertiesComponent;
import org.cyclops.cyclopscore.recipe.custom.component.ItemAndFluidStackRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.ItemStackRecipeComponent;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.cyclopscore.tileentity.TankInventoryTileEntity;
import org.cyclops.integrateddynamics.block.BlockSqueezer;

public class TileSqueezer
extends TankInventoryTileEntity
implements CyclopsTileEntity.ITickingTile {
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    @NBTPersist
    private int itemHeight = 1;
    private SingleCache<ItemStack, IRecipe<ItemStackRecipeComponent, ItemAndFluidStackRecipeComponent, DummyPropertiesComponent>> recipeCache;

    public TileSqueezer() {
        super(1, "squeezerInventory", 1, 1000, "squeezerTank");
        this.addSlotsToSide(EnumFacing.UP, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.DOWN, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.NORTH, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.SOUTH, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.WEST, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.EAST, Sets.newHashSet((Object[])new Integer[]{0}));
        this.recipeCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<ItemStack, IRecipe<ItemStackRecipeComponent, ItemAndFluidStackRecipeComponent, DummyPropertiesComponent>>(){

            public IRecipe<ItemStackRecipeComponent, ItemAndFluidStackRecipeComponent, DummyPropertiesComponent> getNewValue(ItemStack key) {
                ItemStackRecipeComponent recipeInput = new ItemStackRecipeComponent(key);
                return TileSqueezer.this.getRegistry().findRecipeByInput((IRecipeInput)recipeInput);
            }

            public boolean isKeyEqual(ItemStack cacheKey, ItemStack newKey) {
                return ItemStack.func_77989_b((ItemStack)cacheKey, (ItemStack)newKey);
            }
        });
    }

    protected IRecipeRegistry<BlockSqueezer, ItemStackRecipeComponent, ItemAndFluidStackRecipeComponent, DummyPropertiesComponent> getRegistry() {
        return BlockSqueezer.getInstance().getRecipeRegistry();
    }

    public IRecipe<ItemStackRecipeComponent, ItemAndFluidStackRecipeComponent, DummyPropertiesComponent> getCurrentRecipe() {
        return (IRecipe)this.recipeCache.get((Object)this.func_70301_a(0));
    }

    protected void updateTileEntity() {
        super.updateTileEntity();
        if (!this.func_145831_w().field_72995_K) {
            if (!this.getTank().isEmpty()) {
                EnumFacing[] sides;
                for (EnumFacing side : sides = ((BlockSqueezer.EnumAxis)((Object)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b(BlockSqueezer.AXIS))).getSides()) {
                    IFluidHandler handler = (IFluidHandler)TileHelpers.getSafeTile((IBlockAccess)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177972_a(side), IFluidHandler.class);
                    if (this.getTank().isEmpty() || handler == null) continue;
                    FluidStack fluidStack = new FluidStack(this.getTank().getFluidType(), Math.min(100, this.getTank().getFluidAmount()));
                    if (handler.fill(side.func_176734_d(), fluidStack, false) <= 0) continue;
                    int filled = handler.fill(side.func_176734_d(), fluidStack, true);
                    this.drain(filled, true);
                }
            } else if (this.itemHeight == 7 && this.getCurrentRecipe() != null) {
                IRecipe<ItemStackRecipeComponent, ItemAndFluidStackRecipeComponent, DummyPropertiesComponent> recipe = this.getCurrentRecipe();
                this.func_70299_a(0, null);
                ItemStack resultStack = ((ItemAndFluidStackRecipeComponent)recipe.getOutput()).getItemStack();
                if (resultStack != null) {
                    resultStack = resultStack.func_77946_l();
                    for (EnumFacing side : EnumFacing.field_82609_l) {
                        if (resultStack == null || side == EnumFacing.UP) continue;
                        IItemHandler itemHandler = (IItemHandler)TileHelpers.getCapability((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177972_a(side), (EnumFacing)side.func_176734_d(), (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                        resultStack = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)resultStack, (boolean)false);
                    }
                    if (resultStack != null) {
                        ItemStackHelpers.spawnItemStack((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)resultStack);
                    }
                }
                if (((ItemAndFluidStackRecipeComponent)recipe.getOutput()).getFluidStack() != null) {
                    this.fill(((ItemAndFluidStackRecipeComponent)recipe.getOutput()).getFluidStack(), true);
                }
            } else {
                this.sendUpdate();
            }
        }
    }

    public boolean func_180462_a(int slot, ItemStack itemStack, EnumFacing side) {
        return (Integer)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockSqueezer.HEIGHT) == 1 && super.func_180462_a(slot, itemStack, side);
    }

    public void func_70299_a(int slotId, ItemStack itemstack) {
        super.func_70299_a(slotId, itemstack);
        if (itemstack == null) {
            this.itemHeight = 1;
        }
        this.sendUpdate();
    }

    public void setItemHeight(int itemHeight) {
        this.itemHeight = itemHeight;
        this.sendUpdate();
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

