/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.api.block.IVariableContainer;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.tileentity.TileCableConnectableInventory;
import org.cyclops.integrateddynamics.item.ItemVariable;

public class TileVariablestore
extends TileCableConnectableInventory
implements IVariableContainer,
IDirtyMarkListener {
    public static final int ROWS = 5;
    public static final int COLS = 9;
    private Map<Integer, IVariableFacade> variableCache = Maps.newHashMap();

    public TileVariablestore() {
        super(45, "variables", 1);
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        ArrayList slots = Lists.newArrayListWithCapacity((int)this.getInventory().func_70302_i_());
        for (int i = 0; i < this.getInventory().func_70302_i_(); ++i) {
            slots.add(i);
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.addSlotsToSide(side, slots);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.refreshVariables((IInventory)this.inventory);
    }

    protected void refreshVariables(IInventory inventory) {
        this.variableCache.clear();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            IVariableFacade variableFacade;
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null || !(variableFacade = ItemVariable.getInstance().getVariableFacade(itemStack)).isValid()) continue;
            this.variableCache.put(variableFacade.getId(), variableFacade);
        }
        IPartNetwork network = this.getNetwork();
        if (network != null) {
            network.getEventBus().post(new VariableContentsUpdatedEvent(network));
        }
    }

    @Override
    public DimPos getPosition() {
        return DimPos.of((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
    }

    @Override
    public Map<Integer, IVariableFacade> getVariableCache() {
        return this.variableCache;
    }

    public void onDirty() {
        if (!this.field_145850_b.field_72995_K) {
            this.refreshVariables((IInventory)this.inventory);
        }
    }
}

