/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.world.biome;

import java.util.Random;
import net.minecraft.block.BlockFlower;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBiome;
import org.cyclops.cyclopscore.config.extendedconfig.BiomeConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.world.biome.MeneglinBiomeDecorator;

public class BiomeMeneglin
extends ConfigurableBiome {
    private static final BlockFlower.EnumFlowerType[] FLOWERS = new BlockFlower.EnumFlowerType[]{BlockFlower.EnumFlowerType.BLUE_ORCHID, BlockFlower.EnumFlowerType.OXEYE_DAISY, BlockFlower.EnumFlowerType.WHITE_TULIP};
    private static BiomeMeneglin _instance = null;

    public static BiomeMeneglin getInstance() {
        return _instance;
    }

    public BiomeMeneglin(ExtendedConfig<BiomeConfig> eConfig) {
        super((BiomeConfig)eConfig.downCast());
        this.func_150570_a(new BiomeGenBase.Height(0.4f, 0.4f));
        this.func_76732_a(0.75f, 0.25f);
        this.func_76739_b(Helpers.RGBToInt((int)178, (int)226, (int)222));
        this.field_76759_H = Helpers.RGBToInt((int)85, (int)221, (int)168);
        this.field_76760_I.field_76832_z = 3;
        this.field_76760_I.field_76802_A = 70;
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos blockPos) {
        return Helpers.RGBToInt((int)85, (int)221, (int)168);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos blockPos) {
        return Helpers.RGBToInt((int)128, (int)208, (int)185);
    }

    public int func_76731_a(float temp) {
        return Helpers.RGBToInt((int)178, (int)238, (int)233);
    }

    public BiomeDecorator func_76729_a() {
        return this.getModdedBiomeDecorator(new MeneglinBiomeDecorator());
    }

    public BlockFlower.EnumFlowerType func_180623_a(Random rand, BlockPos pos) {
        return FLOWERS[rand.nextInt(FLOWERS.length)];
    }

    public void addDefaultFlowers() {
        for (BlockFlower.EnumFlowerType flower : FLOWERS) {
            this.addFlower(Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)flower), 20);
        }
    }

    @SubscribeEvent
    public void onDecorate(DecorateBiomeEvent.Decorate decorateBiomeEvent) {
        if (decorateBiomeEvent.type == DecorateBiomeEvent.Decorate.EventType.TREE && decorateBiomeEvent.rand.nextInt(GeneralConfig.wildMenrilTreeChance) == 0) {
            int k6 = decorateBiomeEvent.rand.nextInt(16) + 8;
            int l = decorateBiomeEvent.rand.nextInt(16) + 8;
            MeneglinBiomeDecorator.MENRIL_TREE_GEN.func_175904_e();
            BlockPos blockpos = decorateBiomeEvent.world.func_175645_m(decorateBiomeEvent.pos.func_177982_a(k6, 0, l));
            MeneglinBiomeDecorator.MENRIL_TREE_GEN.growTree(decorateBiomeEvent.world, decorateBiomeEvent.rand, blockpos);
        }
    }
}

