/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.world.gen;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.world.gen.WorldGeneratorTree;
import org.cyclops.integrateddynamics.block.BlockMenrilLeavesConfig;
import org.cyclops.integrateddynamics.block.BlockMenrilLogConfig;
import org.cyclops.integrateddynamics.block.BlockMenrilSaplingConfig;

public class WorldGeneratorMenrilTree
extends WorldGeneratorTree {
    public WorldGeneratorMenrilTree(boolean doNotify) {
        super(doNotify);
    }

    protected int baseHeight() {
        return 7;
    }

    protected int baseHeightRandomRange() {
        return 4;
    }

    public BlockLeaves getLeaves() {
        return (BlockLeaves)BlockMenrilLeavesConfig._instance.getBlockInstance();
    }

    public BlockLog getLogs() {
        return (BlockLog)BlockMenrilLogConfig._instance.getBlockInstance();
    }

    public BlockSapling getSapling() {
        return (BlockSapling)BlockMenrilSaplingConfig._instance.getBlockInstance();
    }

    public boolean growTree(World world, Random rand, BlockPos blockPos) {
        int treeHeight = rand.nextInt(this.baseHeightRandomRange()) + this.baseHeight();
        int worldHeight = world.func_72800_K();
        if (blockPos.func_177956_o() >= 1 && blockPos.func_177956_o() + treeHeight + 1 <= worldHeight) {
            BlockPos basePos = blockPos.func_177982_a(0, -1, 0);
            Block block = world.func_180495_p(basePos).func_177230_c();
            int x = blockPos.func_177958_n();
            int y = blockPos.func_177956_o();
            int z = blockPos.func_177952_p();
            if (block != null && block.canSustainPlant((IBlockAccess)world, basePos, EnumFacing.UP, (IPlantable)this.getSapling()) && y < worldHeight - treeHeight - 1) {
                int zOffset;
                int xOffset;
                int yOffset;
                for (yOffset = y; yOffset <= y + 1 + treeHeight; ++yOffset) {
                    int radius = 1;
                    if (yOffset == y) {
                        radius = 0;
                    }
                    if (yOffset >= y + 4) {
                        radius = 3;
                    }
                    if (yOffset >= y + 1 + treeHeight - 3) {
                        radius = 5;
                    }
                    if (yOffset >= y + 1 + treeHeight - 1) {
                        radius = 3;
                    }
                    if (yOffset >= 0 & yOffset < worldHeight) {
                        for (xOffset = x - radius; xOffset <= x + radius; ++xOffset) {
                            for (zOffset = z - radius; zOffset <= z + radius; ++zOffset) {
                                BlockPos loopPos = new BlockPos(xOffset, yOffset, zOffset);
                                block = world.func_180495_p(loopPos).func_177230_c();
                                if (block == null || block.isLeaves((IBlockAccess)world, loopPos) || block == Blocks.field_150350_a || block.canBeReplacedByLeaves((IBlockAccess)world, loopPos)) continue;
                                return false;
                            }
                        }
                        continue;
                    }
                    return false;
                }
                block = world.func_180495_p(basePos).func_177230_c();
                if (block != null) {
                    block.onPlantGrow(world, basePos, blockPos);
                    for (yOffset = y - 5 + treeHeight; yOffset <= y + treeHeight; ++yOffset) {
                        int center = yOffset <= treeHeight && yOffset >= treeHeight - 1 ? 4 : 2;
                        for (xOffset = x - center; xOffset <= x + center; ++xOffset) {
                            int xPos = xOffset - x;
                            int t = xPos >> 31;
                            xPos = xPos + t ^ t;
                            for (zOffset = z - center; zOffset <= z + center; ++zOffset) {
                                int zPos = zOffset - z;
                                t = zPos >> 31;
                                zPos = zPos + t ^ t;
                                BlockPos loopPos = new BlockPos(xOffset, yOffset, zOffset);
                                block = world.func_180495_p(loopPos).func_177230_c();
                                if (!(xPos != center | zPos != center) || (yOffset == y + treeHeight || yOffset == y - 5 + treeHeight) && (xPos == center || zPos == center) || block != null && !block.isLeaves((IBlockAccess)world, loopPos) && block != Blocks.field_150350_a && !block.canBeReplacedByLeaves((IBlockAccess)world, loopPos)) continue;
                                this.func_175903_a(world, loopPos, this.getLeaves().func_176223_P());
                            }
                        }
                    }
                    LinkedList logLocations = Lists.newLinkedList();
                    for (yOffset = 0; yOffset < treeHeight; ++yOffset) {
                        logLocations.add(Pair.of((Object)false, (Object)blockPos.func_177982_a(0, yOffset, 0)));
                        if (yOffset < 1 + treeHeight - 5 || yOffset > 1 + treeHeight - 1) continue;
                        logLocations.add(Pair.of((Object)false, (Object)blockPos.func_177982_a(-1, yOffset, 0)));
                        logLocations.add(Pair.of((Object)false, (Object)blockPos.func_177982_a(1, yOffset, 0)));
                        logLocations.add(Pair.of((Object)false, (Object)blockPos.func_177982_a(0, yOffset, -1)));
                        logLocations.add(Pair.of((Object)false, (Object)blockPos.func_177982_a(0, yOffset, 1)));
                    }
                    logLocations.add(Pair.of((Object)false, (Object)blockPos.func_177982_a(-1, 0, 0)));
                    logLocations.add(Pair.of((Object)false, (Object)blockPos.func_177982_a(1, 0, 0)));
                    logLocations.add(Pair.of((Object)false, (Object)blockPos.func_177982_a(0, 0, -1)));
                    logLocations.add(Pair.of((Object)false, (Object)blockPos.func_177982_a(0, 0, 1)));
                    for (Pair pair : logLocations) {
                        BlockPos loopPos = (BlockPos)pair.getRight();
                        if (block != null && block != Blocks.field_150350_a && !block.isLeaves((IBlockAccess)world, loopPos) && !block.func_176200_f(world, loopPos)) continue;
                        this.func_175903_a(world, loopPos, this.getLogs().func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)((Boolean)pair.getLeft() != false ? BlockLog.EnumAxis.NONE : BlockLog.EnumAxis.Y)));
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

