/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.icon;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.icon.Icon;
import org.cyclops.cyclopscore.proxy.ClientProxyComponent;

@SideOnly(value=Side.CLIENT)
public class IconProvider {
    private final ClientProxyComponent clientProxy;
    private final List<Pair<Pair<Object, Field>, String>> toRegister = Lists.newLinkedList();

    public IconProvider(ClientProxyComponent clientProxy) {
        this.clientProxy = clientProxy;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected void registerIcon(Object object, Field field, String location) {
        this.toRegister.add((Pair<Pair<Object, Field>, String>)Pair.of((Object)Pair.of((Object)object, (Object)field), (Object)location));
    }

    protected TextureAtlasSprite registerIcon(TextureMap textureMap, String location) {
        return textureMap.func_174942_a(new ResourceLocation(this.clientProxy.getMod().getModId(), location));
    }

    @SubscribeEvent
    public void onPreTextureStitch(TextureStitchEvent.Pre event) {
        for (Pair<Pair<Object, Field>, String> entry : this.toRegister) {
            TextureAtlasSprite icon = this.registerIcon(event.map, (String)entry.getValue());
            Object object = ((Pair)entry.getLeft()).getLeft();
            Field field = (Field)((Pair)entry.getLeft()).getRight();
            try {
                field.set(object, icon);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(String.format("The icon field %s in class %s could not be set.", field.getName(), object.getClass().getCanonicalName()));
            }
        }
    }

    public void registerIconHolderObject(Object object) {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Icon.class)) continue;
                Icon annotation = field.getAnnotation(Icon.class);
                this.registerIcon(object, field, annotation.location());
            }
        }
    }
}

