/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.command;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.command.CommandMod;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.cyclopscore.network.packet.debug.PingPongPacketAsync;
import org.cyclops.cyclopscore.network.packet.debug.PingPongPacketComplexAsync;
import org.cyclops.cyclopscore.network.packet.debug.PingPongPacketComplexSync;
import org.cyclops.cyclopscore.network.packet.debug.PingPongPacketSync;

public class CommandDebug
extends CommandMod {
    public static final String NAME = "debug";
    private static final int AMOUNT = 3;

    public CommandDebug(ModBase mod) {
        super(mod, NAME);
    }

    public CommandDebug(ModBase mod, String name) {
        super(mod, NAME);
    }

    @Override
    public String getFullCommand() {
        return super.getFullCommand() + " " + NAME;
    }

    @Override
    protected List<String> getAliases() {
        LinkedList<String> list = new LinkedList<String>();
        list.add(NAME);
        return list;
    }

    @Override
    protected Map<String, ICommand> getSubcommands() {
        HashMap map = Maps.newHashMap();
        map.put("simple_async", new CommandDebugPacket(this.getMod(), new PingPongPacketAsync(3)));
        map.put("simple_sync", new CommandDebugPacket(this.getMod(), new PingPongPacketSync(3)));
        map.put("complex_async", new CommandDebugPacket(this.getMod(), new PingPongPacketComplexAsync(3, "abc", "def")));
        map.put("complex_sync", new CommandDebugPacket(this.getMod(), new PingPongPacketComplexSync(3, "abc", "def")));
        return map;
    }

    @Override
    public void processCommandHelp(ICommandSender icommandsender, String[] astring) throws CommandException {
        Iterator<String> it = this.getSubcommands().keySet().iterator();
        if (!it.hasNext()) {
            throw new CommandException("empty", new Object[0]);
        }
        icommandsender.func_145747_a((IChatComponent)new ChatComponentText(this.joinStrings(it, ", ")));
    }

    public class CommandDebugPacket
    extends CommandMod {
        private final PacketCodec packet;

        public CommandDebugPacket(ModBase mod, PacketCodec packet) {
            super(mod);
            this.packet = packet;
        }

        @Override
        public List func_180525_a(ICommandSender sender, String[] parts, BlockPos blockPos) {
            return null;
        }

        @Override
        public void func_71515_b(ICommandSender sender, String[] parts) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(String.format("Sending %s from client to server...", this.packet.getClass())));
            CyclopsCore._instance.getPacketHandler().sendToPlayer(this.packet, (EntityPlayerMP)sender.func_174793_f());
        }
    }
}

