/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurable;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.block.property.BlockPropertyManagerComponent;
import org.cyclops.cyclopscore.block.property.IBlockPropertyManager;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.config.configurable.IConfigurableBlock;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.BlockContainerConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.cyclopscore.tileentity.TileEntityNBTStorage;

public class ConfigurableBlockContainer
extends BlockContainer
implements IConfigurableBlock,
IDynamicModelElement {
    protected IBlockPropertyManager propertyManager;
    protected BlockConfig eConfig = null;
    protected Random random;
    private Class<? extends CyclopsTileEntity> tileEntity;
    protected boolean hasGui = false;
    private boolean rotatable;
    protected int pass = 0;
    protected boolean isInventoryBlock = false;

    protected BlockState func_180661_e() {
        this.propertyManager = new BlockPropertyManagerComponent((Block)this);
        return this.propertyManager.createDelegatedBlockState();
    }

    public ConfigurableBlockContainer(ExtendedConfig eConfig, Material material, Class<? extends CyclopsTileEntity> tileEntity) {
        super(material);
        this.setConfig(eConfig);
        this.func_149663_c(eConfig.getUnlocalizedName());
        this.random = new Random();
        this.tileEntity = tileEntity;
        this.func_149711_c(5.0f);
        this.func_149672_a(Block.field_149780_i);
        if (this.hasDynamicModel()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState blockState = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        for (IProperty property : blockState.func_177227_a()) {
            if (!property.func_177701_a().equals("facing")) continue;
            blockState = blockState.func_177226_a(property, (Comparable)placer.func_174811_aO());
        }
        return blockState;
    }

    public int func_149645_b() {
        return 3;
    }

    public Class<? extends TileEntity> getTileEntity() {
        return this.tileEntity;
    }

    private void setConfig(ExtendedConfig eConfig) {
        this.eConfig = (BlockConfig)eConfig;
    }

    @Override
    public boolean hasGui() {
        return this.hasGui;
    }

    public TileEntity func_149915_a(World world, int meta) {
        try {
            CyclopsTileEntity tile = this.tileEntity.newInstance();
            tile.onLoad();
            tile.setRotatable(this.isRotatable());
            return tile;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean saveNBTToDroppedItem() {
        return true;
    }

    public boolean destroyBlock(World world, BlockPos pos, boolean dropBlock) {
        this.onPreBlockDestroyed(world, pos);
        boolean result = world.func_175655_b(pos, dropBlock);
        this.onPostBlockDestroyed(world, pos);
        return result;
    }

    protected void onPreBlockDestroyed(World world, BlockPos blockPos, EntityPlayer player) {
        this.onPreBlockDestroyed(world, blockPos);
    }

    protected void onPreBlockDestroyed(World world, BlockPos blockPos) {
        MinecraftHelpers.preDestroyBlock(this, world, blockPos, this.saveNBTToDroppedItem());
    }

    protected void onPostBlockDestroyed(World world, BlockPos blockPos) {
    }

    public void func_180663_b(World world, BlockPos blockPos, IBlockState blockState) {
        super.func_180663_b(world, blockPos, blockState);
        this.onPostBlockDestroyed(world, blockPos);
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.onPreBlockDestroyed(world, pos, player);
        return super.removedByPlayer(world, pos, player, willHarvest);
    }

    public void onBlockExploded(World world, BlockPos blockPos, Explosion explosion) {
        this.onPreBlockDestroyed(world, blockPos, null);
        super.onBlockExploded(world, blockPos, explosion);
        this.onPostBlockDestroyed(world, blockPos);
    }

    public void func_180633_a(World world, BlockPos blockPos, IBlockState blockState, EntityLivingBase entity, ItemStack stack) {
        if (entity != null) {
            CyclopsTileEntity tile = (CyclopsTileEntity)world.func_175625_s(blockPos);
            if (stack.func_77978_p() != null) {
                stack.func_77978_p().func_74768_a("x", blockPos.func_177958_n());
                stack.func_77978_p().func_74768_a("y", blockPos.func_177956_o());
                stack.func_77978_p().func_74768_a("z", blockPos.func_177952_p());
                tile.func_145839_a(stack.func_77978_p());
            }
            if (tile instanceof CyclopsTileEntity.ITickingTile) {
                ((CyclopsTileEntity.ITickingTile)((Object)tile)).func_73660_a();
            }
        }
        super.func_180633_a(world, blockPos, blockState, entity, stack);
    }

    public void writeAdditionalInfo(TileEntity tile, NBTTagCompound tag) {
    }

    public boolean isDropBlockItem(IBlockAccess world, BlockPos pos, IBlockState blockState, int fortune) {
        return true;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState blockState, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Item item = this.func_180660_a(blockState, new Random(), fortune);
        if (item != null && this.isDropBlockItem(world, pos, blockState, fortune)) {
            ItemStack itemStack = new ItemStack(item, 1, this.func_180651_a(blockState));
            if (this.isKeepNBTOnDrop()) {
                if (TileEntityNBTStorage.TAG != null) {
                    itemStack.func_77982_d(TileEntityNBTStorage.TAG);
                }
                if (TileEntityNBTStorage.NAME != null) {
                    itemStack.func_151001_c(TileEntityNBTStorage.NAME);
                }
            }
            drops.add(itemStack);
        }
        MinecraftHelpers.postDestroyBlock(world, pos);
        return drops;
    }

    public boolean isKeepNBTOnDrop() {
        return true;
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    public String getGuiTexture() {
        return this.getGuiTexture("");
    }

    public String getGuiTexture(String suffix) {
        return this.getConfig().getMod().getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + this.eConfig.getNamedId() + "_gui" + suffix + ".png";
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos blockPos, EntityPlayer player) {
        Item item = this.func_180665_b(world, blockPos);
        if (item == null) {
            return null;
        }
        ItemStack itemStack = new ItemStack(item, 1, this.func_176222_j(world, blockPos));
        TileEntity tile = world.func_175625_s(blockPos);
        if (tile instanceof CyclopsTileEntity && this.isKeepNBTOnDrop()) {
            CyclopsTileEntity ecTile = (CyclopsTileEntity)tile;
            itemStack.func_77982_d(ecTile.getNBTTagCompound());
        }
        return itemStack;
    }

    public final BlockContainerConfig getConfig() {
        return (BlockContainerConfig)this.eConfig;
    }

    @Override
    public boolean hasDynamicModel() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBakedModel createDynamicModel() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        if (this.hasDynamicModel()) {
            IBakedModel cableModel = this.createDynamicModel();
            event.modelRegistry.func_82595_a((Object)this.eConfig.dynamicBlockVariantLocation, (Object)cableModel);
            event.modelRegistry.func_82595_a((Object)this.eConfig.dynamicItemVariantLocation, (Object)cableModel);
        }
    }

    public int func_176201_c(IBlockState state) {
        return this.propertyManager.getMetaFromState(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.propertyManager.getStateFromMeta(meta);
    }

    public BlockState createDelegatedBlockState() {
        return this.propertyManager.createDelegatedBlockState();
    }
}

