/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBiome;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.init.ModBase;

public abstract class BiomeConfig
extends ExtendedConfig<BiomeConfig> {
    private int id;

    public BiomeConfig(ModBase mod, int defaultId, String namedId, String comment, Class<? extends BiomeGenBase> element) {
        super(mod, defaultId > 0, namedId, comment, element);
        this.id = defaultId;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getUnlocalizedName() {
        return "biomes." + this.getMod().getModId() + "." + this.getNamedId();
    }

    @Override
    public ConfigurableType getHolderType() {
        return ConfigurableType.BIOME;
    }

    public ConfigurableBiome getBiome() {
        return (ConfigurableBiome)this.getSubInstance();
    }

    public void registerBiomeDictionary() {
        BiomeDictionary.makeBestGuess((BiomeGenBase)this.getBiome());
    }

    @Override
    public boolean isEnabled() {
        return this.getId() != 0;
    }
}

