/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class LocationHelpers {
    private static final Random random = new Random();

    public static NetworkRegistry.TargetPoint createTargetPointFromEntityPosition(Entity entity, int range) {
        return new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (double)range);
    }

    public static NetworkRegistry.TargetPoint createTargetPointFromLocation(World world, BlockPos location, int range) {
        return new NetworkRegistry.TargetPoint(world.field_73011_w.func_177502_q(), (double)location.func_177958_n(), (double)location.func_177956_o(), (double)location.func_177952_p(), (double)range);
    }

    public static BlockPos getRandomPointInSphere(BlockPos center, int radius) {
        BlockPos randomPoint = null;
        while (randomPoint == null) {
            BlockPos coordinates = center.func_177982_a(-radius + random.nextInt(2 * radius), -radius + random.nextInt(2 * radius), -radius + random.nextInt(2 * radius));
            double totalDistance = center.func_177951_i((Vec3i)coordinates);
            if ((int)Math.sqrt(totalDistance) > radius) continue;
            randomPoint = coordinates;
        }
        return randomPoint;
    }

    public static BlockPos copyLocation(BlockPos blockPos) {
        return new BlockPos(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    public static Vec3i copyLocation(Vec3i blockPos) {
        return new Vec3i(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    public static BlockPos addToDimension(BlockPos blockPos, int dimension, int value) {
        if (dimension == 0) {
            return blockPos.func_177982_a(value, 0, 0);
        }
        if (dimension == 1) {
            return blockPos.func_177982_a(0, value, 0);
        }
        if (dimension == 2) {
            return blockPos.func_177982_a(0, 0, value);
        }
        return blockPos;
    }

    public static BlockPos fromArray(int[] coordinates) {
        return new BlockPos(coordinates[0], coordinates[1], coordinates[2]);
    }

    public static int[] toArray(Vec3i blockPos) {
        return new int[]{blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()};
    }

    public static BlockPos subtract(BlockPos blockPos, Vec3i vec) {
        return new BlockPos(blockPos.func_177958_n() - vec.func_177958_n(), blockPos.func_177956_o() - vec.func_177956_o(), blockPos.func_177952_p() - vec.func_177952_p());
    }

    public static Vec3i subtract(Vec3i vec1, Vec3i vec2) {
        return new Vec3i(vec1.func_177958_n() - vec2.func_177958_n(), vec1.func_177956_o() - vec2.func_177956_o(), vec1.func_177952_p() - vec2.func_177952_p());
    }

    public static double getYaw(BlockPos start, BlockPos end) {
        double dX = start.func_177958_n() - end.func_177958_n();
        double dY = start.func_177956_o() - end.func_177956_o();
        double dZ = start.func_177952_p() - end.func_177952_p();
        return Math.atan2(dZ, dX) * 180.0 / Math.PI;
    }

    public static double getPitch(BlockPos start, BlockPos end) {
        double dX = start.func_177958_n() - end.func_177958_n();
        double dY = start.func_177956_o() - end.func_177956_o();
        double dZ = start.func_177952_p() - end.func_177952_p();
        return (Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI) * 180.0 / Math.PI;
    }

    public static String toCompactString(BlockPos pos) {
        return String.format("x: %s ; y: %s ;z: %s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static String toCompactString(Vec3i vec) {
        return String.format("%sx%sx%s", vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }
}

