/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.cyclops.cyclopscore.datastructure.DimPos;

public final class TileHelpers {
    public static <T> T getSafeTile(DimPos dimPos, Class<T> targetClazz) {
        return TileHelpers.getSafeTile((IBlockAccess)dimPos.getWorld(), dimPos.getBlockPos(), targetClazz);
    }

    public static <T> T getSafeTile(IBlockAccess world, BlockPos pos, Class<T> targetClazz) {
        TileEntity tile = world.func_175625_s(pos);
        try {
            return targetClazz.cast(tile);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static <C> C getCapability(World world, BlockPos pos, EnumFacing side, Capability<C> capability) {
        TileEntity tile = TileHelpers.getSafeTile((IBlockAccess)world, pos, TileEntity.class);
        if (tile != null && tile.hasCapability(capability, side)) {
            return (C)tile.getCapability(capability, side);
        }
        return null;
    }
}

