/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet.debug;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.cyclopscore.network.packet.debug.PingPongPacketSync;

public class PingPongPacketAsync
extends PacketCodec {
    @CodecField
    protected int remaining;

    public PingPongPacketAsync() {
    }

    public PingPongPacketAsync(int remaining) {
        this.remaining = remaining;
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    protected void log(EntityPlayer player, String message) {
        player.func_146105_b((IChatComponent)new ChatComponentText(message));
    }

    protected PingPongPacketAsync newPacket() {
        return new PingPongPacketSync(this.remaining - 1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
        if (this.remaining > 0) {
            CyclopsCore._instance.getPacketHandler().sendToServer(this.newPacket());
        }
        this.log(player, String.format("[PING %s] Fields: %s", this.remaining, this.toString()));
    }

    @Override
    public void actionServer(World world, EntityPlayerMP player) {
        if (this.remaining > 0) {
            CyclopsCore._instance.getPacketHandler().sendToPlayer(this.newPacket(), player);
        }
        this.log((EntityPlayer)player, String.format("[PONG %s] Fields: %s", this.remaining, this.toString()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        List fields = (List)this.fieldCache.get(null);
        for (Field field : fields) {
            sb.append(" ");
            sb.append(field);
            sb.append("=");
            try {
                sb.append(field.get(this));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                sb.append("ERROR(" + e.getMessage() + ")");
            }
        }
        return sb.toString();
    }
}

