/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.proxy;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.client.icon.IconProvider;
import org.cyclops.cyclopscore.client.key.IKeyRegistry;
import org.cyclops.cyclopscore.network.PacketHandler;
import org.cyclops.cyclopscore.proxy.CommonProxyComponent;
import org.cyclops.cyclopscore.proxy.ICommonProxy;

public abstract class ClientProxyComponent
extends CommonProxyComponent
implements ICommonProxy {
    protected static final String SOUND_NONE = "none";
    private final CommonProxyComponent commonProxyComponent;
    private final IconProvider iconProvider;
    protected final Map<Class<? extends Entity>, Render> entityRenderers = Maps.newHashMap();
    protected final Map<Class<? extends TileEntity>, TileEntitySpecialRenderer> tileEntityRenderers = Maps.newHashMap();

    public ClientProxyComponent(CommonProxyComponent commonProxyComponent) {
        this.commonProxyComponent = commonProxyComponent;
        this.iconProvider = this.constructIconProvider();
    }

    protected IconProvider constructIconProvider() {
        return new IconProvider(this);
    }

    @Override
    public void registerRenderer(Class<? extends Entity> clazz, Render renderer) {
        this.entityRenderers.put(clazz, renderer);
    }

    @Override
    public void registerRenderer(Class<? extends TileEntity> clazz, TileEntitySpecialRenderer renderer) {
        this.tileEntityRenderers.put(clazz, renderer);
    }

    @Override
    public void registerRenderers() {
        for (Map.Entry<Class<? extends Entity>, Render> entry : this.entityRenderers.entrySet()) {
            RenderingRegistry.registerEntityRenderingHandler(entry.getKey(), (Render)entry.getValue());
            this.getMod().getLoggerHelper().log(Level.TRACE, String.format("Registered %s renderer %s", entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<Class<? extends Entity>, Render> entry : this.tileEntityRenderers.entrySet()) {
            ClientRegistry.bindTileEntitySpecialRenderer(entry.getKey(), (TileEntitySpecialRenderer)((TileEntitySpecialRenderer)entry.getValue()));
            this.getMod().getLoggerHelper().log(Level.TRACE, String.format("Registered %s special renderer %s", entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public void registerKeyBindings(IKeyRegistry keyRegistry) {
        this.getMod().getLoggerHelper().log(Level.TRACE, "Registered key bindings");
    }

    @Override
    public void registerPacketHandlers(PacketHandler packetHandler) {
        this.commonProxyComponent.registerPacketHandlers(packetHandler);
        this.getMod().getLoggerHelper().log(Level.TRACE, "Registered packet handlers");
    }

    @Override
    public void registerTickHandlers() {
        this.commonProxyComponent.registerTickHandlers();
        this.getMod().getLoggerHelper().log(Level.TRACE, "Registered tick handlers");
    }

    @Override
    public void registerEventHooks() {
        this.commonProxyComponent.registerEventHooks();
        this.getMod().getLoggerHelper().log(Level.TRACE, "Registered event hooks");
        FMLCommonHandler.instance().bus().register((Object)this.getMod().getKeyRegistry());
    }

    @Override
    public void playSound(double x, double y, double z, String sound, float volume, float frequency, String mod) {
        if (!SOUND_NONE.equals(sound)) {
            ResourceLocation soundLocation = new ResourceLocation(mod, sound);
            PositionedSoundRecord record = new PositionedSoundRecord(soundLocation, volume, frequency, (float)x, (float)y, (float)z);
            if (!mod.equals("minecraft") && FMLClientHandler.instance().getClient().func_147118_V().func_147680_a(record.func_147650_b()) == null) {
                this.playSoundMinecraft(x, y, z, sound, volume, frequency);
            } else {
                FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)record);
            }
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientProxyComponent)) {
            return false;
        }
        ClientProxyComponent other = (ClientProxyComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommonProxyComponent this$commonProxyComponent = this.getCommonProxyComponent();
        CommonProxyComponent other$commonProxyComponent = other.getCommonProxyComponent();
        if (this$commonProxyComponent == null ? other$commonProxyComponent != null : !this$commonProxyComponent.equals(other$commonProxyComponent)) {
            return false;
        }
        IconProvider this$iconProvider = this.getIconProvider();
        IconProvider other$iconProvider = other.getIconProvider();
        if (this$iconProvider == null ? other$iconProvider != null : !this$iconProvider.equals(other$iconProvider)) {
            return false;
        }
        Map<Class<? extends Entity>, Render> this$entityRenderers = this.getEntityRenderers();
        Map<Class<? extends Entity>, Render> other$entityRenderers = other.getEntityRenderers();
        if (this$entityRenderers == null ? other$entityRenderers != null : !((Object)this$entityRenderers).equals(other$entityRenderers)) {
            return false;
        }
        Map<Class<? extends TileEntity>, TileEntitySpecialRenderer> this$tileEntityRenderers = this.getTileEntityRenderers();
        Map<Class<? extends TileEntity>, TileEntitySpecialRenderer> other$tileEntityRenderers = other.getTileEntityRenderers();
        return !(this$tileEntityRenderers == null ? other$tileEntityRenderers != null : !((Object)this$tileEntityRenderers).equals(other$tileEntityRenderers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientProxyComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommonProxyComponent $commonProxyComponent = this.getCommonProxyComponent();
        result = result * 59 + ($commonProxyComponent == null ? 0 : $commonProxyComponent.hashCode());
        IconProvider $iconProvider = this.getIconProvider();
        result = result * 59 + ($iconProvider == null ? 0 : $iconProvider.hashCode());
        Map<Class<? extends Entity>, Render> $entityRenderers = this.getEntityRenderers();
        result = result * 59 + ($entityRenderers == null ? 0 : ((Object)$entityRenderers).hashCode());
        Map<Class<? extends TileEntity>, TileEntitySpecialRenderer> $tileEntityRenderers = this.getTileEntityRenderers();
        result = result * 59 + ($tileEntityRenderers == null ? 0 : ((Object)$tileEntityRenderers).hashCode());
        return result;
    }

    public CommonProxyComponent getCommonProxyComponent() {
        return this.commonProxyComponent;
    }

    public IconProvider getIconProvider() {
        return this.iconProvider;
    }

    public Map<Class<? extends Entity>, Render> getEntityRenderers() {
        return this.entityRenderers;
    }

    public Map<Class<? extends TileEntity>, TileEntitySpecialRenderer> getTileEntityRenderers() {
        return this.tileEntityRenderers;
    }

    public String toString() {
        return "ClientProxyComponent(commonProxyComponent=" + this.getCommonProxyComponent() + ", iconProvider=" + this.getIconProvider() + ", entityRenderers=" + this.getEntityRenderers() + ", tileEntityRenderers=" + this.getTileEntityRenderers() + ")";
    }
}

