/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.proxy;

import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.client.key.IKeyRegistry;
import org.cyclops.cyclopscore.event.ConfigChangedEventHook;
import org.cyclops.cyclopscore.event.PlayerRingOfFire;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.item.IBucketRegistry;
import org.cyclops.cyclopscore.network.PacketHandler;
import org.cyclops.cyclopscore.network.packet.SoundPacket;
import org.cyclops.cyclopscore.proxy.ICommonProxy;
import org.cyclops.cyclopscore.world.gen.IRetroGenRegistry;

public abstract class CommonProxyComponent
implements ICommonProxy {
    protected static final String DEFAULT_RESOURCELOCATION_MOD = "minecraft";

    @Override
    public void registerRenderer(Class<? extends Entity> clazz, Render renderer) {
        throw new IllegalArgumentException("Registration of renderers should not be called server side!");
    }

    @Override
    public void registerRenderer(Class<? extends TileEntity> clazz, TileEntitySpecialRenderer renderer) {
        throw new IllegalArgumentException("Registration of renderers should not be called server side!");
    }

    @Override
    public void registerRenderers() {
    }

    @Override
    public void registerKeyBindings(IKeyRegistry keyRegistry) {
    }

    @Override
    public void registerPacketHandlers(PacketHandler packetHandler) {
    }

    @Override
    public void registerTickHandlers() {
    }

    @Override
    public void registerEventHooks() {
        IBucketRegistry bucketRegistry;
        IRetroGenRegistry retroGenRegistry = this.getMod().getRegistryManager().getRegistry(IRetroGenRegistry.class);
        if (retroGenRegistry != null) {
            MinecraftForge.EVENT_BUS.register((Object)retroGenRegistry);
        }
        if ((bucketRegistry = this.getMod().getRegistryManager().getRegistry(IBucketRegistry.class)) != null) {
            MinecraftForge.EVENT_BUS.register((Object)bucketRegistry);
        }
        FMLCommonHandler.instance().bus().register((Object)new PlayerRingOfFire());
        FMLCommonHandler.instance().bus().register((Object)new ConfigChangedEventHook(this.getMod()));
    }

    @Override
    public void playSoundMinecraft(BlockPos pos, String sound, float volume, float frequency) {
        this.playSoundMinecraft(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), sound, volume, frequency);
    }

    @Override
    public void playSoundMinecraft(double x, double y, double z, String sound, float volume, float frequency) {
        this.playSound(x, y, z, sound, volume, frequency, DEFAULT_RESOURCELOCATION_MOD);
    }

    @Override
    public void playSound(double x, double y, double z, String sound, float volume, float frequency, String mod) {
    }

    @Override
    public void playSound(double x, double y, double z, String sound, float volume, float frequency) {
        this.playSound(x, y, z, sound, volume, frequency, this.getMod().getModId());
    }

    @Override
    public void sendSoundMinecraft(BlockPos pos, String sound, float volume, float frequency) {
        this.sendSound(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), sound, volume, frequency, DEFAULT_RESOURCELOCATION_MOD);
    }

    @Override
    public void sendSoundMinecraft(double x, double y, double z, String sound, float volume, float frequency) {
        this.sendSound(x, y, z, sound, volume, frequency, DEFAULT_RESOURCELOCATION_MOD);
    }

    @Override
    public void sendSound(double x, double y, double z, String sound, float volume, float frequency, String mod) {
        SoundPacket packet = new SoundPacket(x, y, z, sound, volume, frequency, mod);
        if (!MinecraftHelpers.isClientSide()) {
            CyclopsCore._instance.getPacketHandler().sendToAll(packet);
        } else {
            CyclopsCore._instance.getPacketHandler().sendToServer(packet);
        }
    }

    @Override
    public void sendSound(double x, double y, double z, String sound, float volume, float frequency) {
        this.sendSound(x, y, z, sound, volume, frequency, this.getMod().getModId());
    }
}

