/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.world.gen;

import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.world.gen.IRetroGenRegistry;
import org.cyclops.cyclopscore.world.gen.WorldGenMinableExtended;

public class SimpleMinableWorldGenerator
implements IWorldGenerator {
    private List<WorldGenMinableExtended> worldGenerators;

    public SimpleMinableWorldGenerator(ModBase mod, List<WorldGenMinableExtended> worldGenerators) {
        this.worldGenerators = worldGenerators;
        IRetroGenRegistry registry = mod.getRegistryManager().getRegistry(IRetroGenRegistry.class);
        if (registry != null) {
            for (WorldGenMinableExtended gen : worldGenerators) {
                registry.registerRetroGen(gen);
            }
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        for (WorldGenMinableExtended worldGen : this.worldGenerators) {
            worldGen.loopGenerate(world, random, chunkX * 16, chunkZ * 16);
        }
    }
}

