/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.model;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.cyclops.cyclopscore.client.model.DirectionCorner;
import org.cyclops.cyclopscore.client.model.DynamicBaseModel;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockConnectedTexture;
import org.cyclops.cyclopscore.helper.BlockHelpers;

public class ConnectedBlockModel
extends DynamicBaseModel {
    protected static final EnumFacing[][] CONNECT_MATRIX = new EnumFacing[][]{{EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.SOUTH, EnumFacing.EAST}, {EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.SOUTH, EnumFacing.DOWN, EnumFacing.NORTH}, {EnumFacing.UP, EnumFacing.NORTH, EnumFacing.DOWN, EnumFacing.SOUTH}};
    protected static final DirectionCorner[][] CONNECT_CORNER_MATRIX = new DirectionCorner[][]{{DirectionCorner.MIDDLE_NORTHWEST, DirectionCorner.MIDDLE_SOUTHWEST, DirectionCorner.MIDDLE_SOUTHEAST, DirectionCorner.MIDDLE_NORTHEAST}, {DirectionCorner.MIDDLE_NORTHWEST, DirectionCorner.MIDDLE_NORTHEAST, DirectionCorner.MIDDLE_SOUTHEAST, DirectionCorner.MIDDLE_SOUTHWEST}, {DirectionCorner.UPPER_EAST, DirectionCorner.UPPER_WEST, DirectionCorner.LOWER_WEST, DirectionCorner.LOWER_EAST}, {DirectionCorner.UPPER_WEST, DirectionCorner.UPPER_EAST, DirectionCorner.LOWER_EAST, DirectionCorner.LOWER_WEST}, {DirectionCorner.UPPER_NORTH, DirectionCorner.UPPER_SOUTH, DirectionCorner.LOWER_SOUTH, DirectionCorner.LOWER_NORTH}, {DirectionCorner.UPPER_SOUTH, DirectionCorner.UPPER_NORTH, DirectionCorner.LOWER_NORTH, DirectionCorner.LOWER_SOUTH}};
    private final ConfigurableBlockConnectedTexture block;

    public ConnectedBlockModel(ConfigurableBlockConnectedTexture block) {
        this.block = block;
    }

    @Override
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        float[][] v = UVS;
        boolean itemStack = !(state instanceof IExtendedBlockState);
        IExtendedBlockState extendedState = null;
        if (!itemStack) {
            extendedState = (IExtendedBlockState)state;
        }
        LinkedList ret = Lists.newLinkedList();
        TextureAtlasSprite backgroundTexture = this.func_177554_e();
        TextureAtlasSprite sideTexture = this.block.getTexture("border");
        TextureAtlasSprite cornerTexture = this.block.getTexture("corner");
        TextureAtlasSprite innerCornerTexture = this.block.getTexture("innerCorner");
        for (EnumFacing facing : EnumFacing.values()) {
            EnumFacing realSide;
            int rotation;
            if (!itemStack && BlockHelpers.getSafeBlockStateProperty(extendedState, ConfigurableBlockConnectedTexture.CONNECTED[facing.ordinal()], Boolean.valueOf(false)).booleanValue()) continue;
            ConnectedBlockModel.addBakedQuad(ret, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, backgroundTexture, facing);
            for (rotation = 0; rotation < 4; ++rotation) {
                boolean isConnected;
                int ar = (rotation + ROTATION_FIX[facing.ordinal()]) % 4;
                realSide = CONNECT_MATRIX[facing.ordinal()][rotation];
                boolean bl = isConnected = !itemStack && BlockHelpers.getSafeBlockStateProperty(extendedState, ConfigurableBlockConnectedTexture.CONNECTED[realSide.ordinal()], Boolean.valueOf(false)) != false;
                if (isConnected) continue;
                ConnectedBlockModel.addBakedQuadRotated(ret, v[0][0], v[1][0], v[0][1], v[1][1], 1.0f, sideTexture, facing, ar);
            }
            for (rotation = 0; rotation < 4; ++rotation) {
                boolean isCornerConnected;
                int arPrev = (rotation + 3 + ROTATION_FIX[facing.ordinal()]) % 4;
                realSide = CONNECT_MATRIX[facing.ordinal()][rotation];
                EnumFacing realSidePrev = CONNECT_MATRIX[facing.ordinal()][(rotation + 3) % 4];
                DirectionCorner corner = CONNECT_CORNER_MATRIX[facing.ordinal()][rotation];
                boolean isConnected = !itemStack && BlockHelpers.getSafeBlockStateProperty(extendedState, ConfigurableBlockConnectedTexture.CONNECTED[realSide.ordinal()], Boolean.valueOf(false)) != false;
                boolean isConnectedPrev = !itemStack && BlockHelpers.getSafeBlockStateProperty(extendedState, ConfigurableBlockConnectedTexture.CONNECTED[realSidePrev.ordinal()], Boolean.valueOf(false)) != false;
                boolean bl = isCornerConnected = !itemStack && BlockHelpers.getSafeBlockStateProperty(extendedState, ConfigurableBlockConnectedTexture.CONNECTED_CORNER[corner.ordinal()], Boolean.valueOf(false)) != false;
                if (!isConnected && !isConnectedPrev) {
                    ConnectedBlockModel.addBakedQuadRotated(ret, v[0][0], v[1][0], v[0][1], v[1][1], 1.0f, cornerTexture, facing, arPrev);
                }
                if (!isConnected || !isConnectedPrev || isCornerConnected) continue;
                ConnectedBlockModel.addBakedQuadRotated(ret, v[0][0], v[1][0], v[0][1], v[1][1], 1.0f, innerCornerTexture, facing, arPrev);
            }
        }
        return ret;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.block.getTexture("background");
    }
}

