/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.datastructure;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class DimPos
implements Comparable<DimPos> {
    private final World world;
    private final BlockPos blockPos;

    @Override
    public int compareTo(DimPos o) {
        int compareDim = Integer.compare(this.getWorld().field_73011_w.getDimension(), o.getWorld().field_73011_w.getDimension());
        if (compareDim == 0) {
            return MinecraftHelpers.compareBlockPos(this.getBlockPos(), o.getBlockPos());
        }
        return compareDim;
    }

    public boolean equals(Object o) {
        return o instanceof DimPos && this.compareTo((DimPos)o) == 0;
    }

    public int hashCode() {
        return 31 * this.world.field_73011_w.getDimension() + this.blockPos.hashCode();
    }

    private DimPos(World world, BlockPos blockPos) {
        this.world = world;
        this.blockPos = blockPos;
    }

    public static DimPos of(World world, BlockPos blockPos) {
        return new DimPos(world, blockPos);
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public String toString() {
        return "DimPos(world=" + this.getWorld() + ", blockPos=" + this.getBlockPos() + ")";
    }
}

