/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityHelpers {
    public static final String NBTTAG_ID = "id";

    public static void onEntityCollided(World world, BlockPos blockPos, Entity entity) {
        Block block;
        if (blockPos != null && (block = world.func_180495_p(blockPos).func_177230_c()) != null) {
            block.func_176199_a(world, blockPos, entity);
        }
    }

    public static List<Entity> getEntitiesInArea(World world, BlockPos blockPos, int area) {
        AxisAlignedBB box = new AxisAlignedBB((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()).func_72314_b((double)area, (double)area, (double)area);
        List entities = world.func_72872_a(Entity.class, box);
        return entities;
    }

    public static boolean spawnEntity(World world, EntityLiving entityLiving) {
        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityLiving, (World)world, (float)((float)entityLiving.field_70165_t), (float)((float)entityLiving.field_70163_u), (float)((float)entityLiving.field_70161_v));
        if (!(canSpawn != Event.Result.ALLOW && canSpawn != Event.Result.DEFAULT || ForgeEventFactory.doSpecialSpawn((EntityLiving)entityLiving, (World)world, (float)((float)entityLiving.field_70165_t), (float)((float)entityLiving.field_70163_u), (float)((float)entityLiving.field_70161_v)))) {
            world.func_72838_d((Entity)entityLiving);
            return true;
        }
        return false;
    }

    public static Vec3i getEntitySize(Entity entity) {
        int x = (int)Math.ceil(entity.field_70130_N);
        int y = (int)Math.ceil(entity.field_70131_O);
        int z = x;
        return new Vec3i(x, y, z);
    }

    public static void spawnXpAtPlayer(World world, EntityPlayer player, int xp) {
        if (!world.field_72995_K) {
            while (xp > 0) {
                int current = EntityXPOrb.func_70527_a((int)xp);
                xp -= current;
                world.func_72838_d((Entity)new EntityXPOrb(world, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v + 0.5, current));
            }
        }
    }
}

