/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.xml;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.recipe.xml.GridRecipeTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.XmlRecipeLoader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ShapedRecipeTypeHandler
extends GridRecipeTypeHandler {
    @Override
    protected void handleIO(RecipeHandler recipeHandler, Element input, ItemStack output) throws XmlRecipeLoader.XmlRecipeException {
        Element inputGrid = (Element)input.getElementsByTagName("grid").item(0);
        NodeList gridRows = inputGrid.getElementsByTagName("gridrow");
        char parameterCounter = 'A';
        LinkedList lines = Lists.newLinkedList();
        HashMap parameters = Maps.newHashMap();
        for (int row = 0; row < gridRows.getLength(); ++row) {
            String parameterLine = "";
            Element gridRow = (Element)gridRows.item(row);
            NodeList gridColumns = gridRow.getElementsByTagName("item");
            for (int col = 0; col < gridColumns.getLength(); ++col) {
                Node gridColumn = gridColumns.item(col);
                Object item = this.getItem(recipeHandler, gridColumn);
                if (item == null) {
                    parameterLine = parameterLine + " ";
                    continue;
                }
                if (!parameters.containsKey(item)) {
                    char c = parameterCounter;
                    parameterCounter = (char)(parameterCounter + 1);
                    parameters.put(item, Character.valueOf(c));
                }
                char parameter = ((Character)parameters.get(item)).charValue();
                parameterLine = parameterLine + parameter;
            }
            lines.add(parameterLine);
        }
        for (Map.Entry entry : parameters.entrySet()) {
            lines.add(entry.getValue());
            if (entry.getKey() == null) {
                throw new XmlRecipeLoader.XmlRecipeException(String.format("The recipe %s -> %s has an invalid structure.", input.toString(), output.toString()));
            }
            lines.add(entry.getKey());
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, new Object[]{true, lines.toArray()}));
    }
}

