/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.inventorystate;

import java.util.Objects;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.api.capability.inventorystate.IInventoryState;

public class ItemHandlerInventoryState
implements IInventoryState,
IItemHandler {
    private static final Random RAND = new Random();
    private final IItemHandler itemHandler;
    private int hash;

    public ItemHandlerInventoryState(IItemHandler itemHandler) {
        this.itemHandler = Objects.requireNonNull(itemHandler);
    }

    protected void setNewHash() {
        int lastHash = this.hash;
        while (lastHash == this.hash) {
            this.hash = RAND.nextInt();
        }
    }

    @Override
    public int getHash() {
        return this.hash;
    }

    public int getSlots() {
        return this.itemHandler.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!simulate) {
            this.setNewHash();
        }
        return this.itemHandler.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!simulate) {
            this.setNewHash();
        }
        return this.itemHandler.extractItem(slot, amount, simulate);
    }
}

