/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.IWorldNameable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.UniversalBucket;
import org.cyclops.commoncapabilities.CommonCapabilities;
import org.cyclops.commoncapabilities.api.capability.temperature.ITemperature;
import org.cyclops.commoncapabilities.api.capability.work.IWorker;
import org.cyclops.commoncapabilities.capability.temperature.TemperatureConfig;
import org.cyclops.commoncapabilities.capability.worker.WorkerConfig;
import org.cyclops.commoncapabilities.capability.worldnameable.EntityLivingWorldNameable;
import org.cyclops.commoncapabilities.capability.worldnameable.ItemStackWorldNameable;
import org.cyclops.commoncapabilities.capability.worldnameable.WorldNameableConfig;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.temperature.VanillaFurnaceTemperature;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.temperature.VanillaUniversalBucketTemperature;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.work.VanillaBrewingStandWorker;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.work.VanillaFurnaceWorker;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.modcompat.IModCompat;
import org.cyclops.cyclopscore.modcompat.capabilities.CapabilityConstructorRegistry;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultCapabilityProvider;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;
import org.cyclops.cyclopscore.modcompat.capabilities.SimpleCapabilityConstructor;

public class VanillaModCompat
implements IModCompat {
    public String getModID() {
        return "Minecraft";
    }

    public boolean isEnabled() {
        return true;
    }

    public String getComment() {
        return "Furnace and Brewing stand capabilities.";
    }

    public void onInit(IInitListener.Step initStep) {
        if (initStep == IInitListener.Step.INIT) {
            CapabilityConstructorRegistry registry = CommonCapabilities._instance.getCapabilityConstructorRegistry();
            registry.registerTile(TileEntityFurnace.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, TileEntityFurnace>(){

                public Capability<IWorker> getCapability() {
                    return WorkerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(TileEntityFurnace host) {
                    return new DefaultCapabilityProvider(WorkerConfig.CAPABILITY, (Object)new VanillaFurnaceWorker(host));
                }
            });
            registry.registerTile(TileEntityBrewingStand.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, TileEntityBrewingStand>(){

                public Capability<IWorker> getCapability() {
                    return WorkerConfig.CAPABILITY;
                }

                public ICapabilityProvider createProvider(TileEntityBrewingStand host) {
                    return new DefaultCapabilityProvider(WorkerConfig.CAPABILITY, (Object)new VanillaBrewingStandWorker(host));
                }
            });
            registry.registerInheritableTile(IWorldNameable.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorldNameable, TileEntity>(){

                public Capability<IWorldNameable> getCapability() {
                    return WorldNameableConfig.CAPABILITY;
                }

                public ICapabilityProvider createProvider(TileEntity host) {
                    return new DefaultCapabilityProvider(WorldNameableConfig.CAPABILITY, (Object)((IWorldNameable)host));
                }
            });
            registry.registerInheritableEntity(IWorldNameable.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorldNameable, Entity>(){

                public Capability<IWorldNameable> getCapability() {
                    return WorldNameableConfig.CAPABILITY;
                }

                public ICapabilityProvider createProvider(Entity host) {
                    return new DefaultCapabilityProvider(WorldNameableConfig.CAPABILITY, (Object)((IWorldNameable)host));
                }
            });
            registry.registerInheritableEntity(EntityLiving.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorldNameable, EntityLiving>(){

                public Capability<IWorldNameable> getCapability() {
                    return WorldNameableConfig.CAPABILITY;
                }

                public ICapabilityProvider createProvider(EntityLiving host) {
                    return new DefaultCapabilityProvider(WorldNameableConfig.CAPABILITY, (Object)new EntityLivingWorldNameable(host));
                }
            });
            registry.registerInheritableItem(Item.class, (ICapabilityConstructor)new ICapabilityConstructor<IWorldNameable, Item, ItemStack>(){

                public Capability<IWorldNameable> getCapability() {
                    return WorldNameableConfig.CAPABILITY;
                }

                public ICapabilityProvider createProvider(Item hostType, ItemStack host) {
                    if (host.func_82837_s()) {
                        return new DefaultCapabilityProvider(WorldNameableConfig.CAPABILITY, (Object)new ItemStackWorldNameable(host));
                    }
                    return null;
                }
            });
            registry.registerTile(TileEntityFurnace.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<ITemperature, TileEntityFurnace>(){

                public Capability<ITemperature> getCapability() {
                    return TemperatureConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(TileEntityFurnace host) {
                    return new DefaultCapabilityProvider(TemperatureConfig.CAPABILITY, (Object)new VanillaFurnaceTemperature(host));
                }
            });
            registry.registerItem(UniversalBucket.class, (ICapabilityConstructor)new ICapabilityConstructor<ITemperature, UniversalBucket, ItemStack>(){

                public Capability<ITemperature> getCapability() {
                    return TemperatureConfig.CAPABILITY;
                }

                public ICapabilityProvider createProvider(UniversalBucket hostType, ItemStack host) {
                    return new DefaultCapabilityProvider(TemperatureConfig.CAPABILITY, (Object)new VanillaUniversalBucketTemperature(host));
                }
            });
        }
    }
}

