/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.container;

import java.awt.Rectangle;
import net.minecraft.client.gui.FontRenderer;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonImage;
import org.cyclops.cyclopscore.client.gui.container.GuiContainerExtended;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.client.gui.container.DisplayErrorsComponent;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipart;
import org.cyclops.integrateddynamics.core.part.PartTypeConfigurable;

public abstract class GuiMultipart<P extends IPartType<P, S> & IGuiContainerProvider, S extends IPartState<P>>
extends GuiContainerExtended {
    private static final Rectangle ITEM_POSITION = new Rectangle(8, 17, 18, 18);
    protected final DisplayErrorsComponent displayErrors = new DisplayErrorsComponent();
    private final PartTarget target;
    private final IPartContainer partContainer;
    private final P partType;

    public GuiMultipart(ContainerMultipart<P, S> container) {
        super(container);
        this.target = container.getTarget();
        this.partContainer = container.getPartContainer();
        this.partType = container.getPartType();
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        super.func_73866_w_();
        if (this.getPartType() instanceof PartTypeConfigurable && ((PartTypeConfigurable)this.getPartType()).hasSettings()) {
            this.field_146292_n.add(new GuiButtonImage(1, this.field_147003_i + 174, this.field_147009_r + 4, 15, 15, (IImage)Images.CONFIG_BOARD, -2, -3, true));
        }
    }

    public S getPartState() {
        return ((ContainerMultipart)this.container).getPartState();
    }

    protected abstract String getNameId();

    public String getGuiTexture() {
        return (String)this.getContainer().getGuiProvider().getMod().getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + this.getNameId() + ".png";
    }

    protected float colorSmoothener(float color) {
        return 1.0f - (1.0f - color) / 4.0f;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        FontRenderer fontRenderer = this.field_146289_q;
        fontRenderer.func_78276_b(L10NHelpers.localize((String)this.getPartType().getUnlocalizedName()), this.field_147003_i + 8, this.field_147009_r + 6, Helpers.RGBToInt((int)0, (int)0, (int)0));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuiMultipart)) {
            return false;
        }
        GuiMultipart other = (GuiMultipart)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DisplayErrorsComponent this$displayErrors = this.getDisplayErrors();
        DisplayErrorsComponent other$displayErrors = other.getDisplayErrors();
        if (this$displayErrors == null ? other$displayErrors != null : !this$displayErrors.equals(other$displayErrors)) {
            return false;
        }
        PartTarget this$target = this.getTarget();
        PartTarget other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        IPartContainer this$partContainer = this.getPartContainer();
        IPartContainer other$partContainer = other.getPartContainer();
        if (this$partContainer == null ? other$partContainer != null : !this$partContainer.equals(other$partContainer)) {
            return false;
        }
        P this$partType = this.getPartType();
        P other$partType = other.getPartType();
        return !(this$partType == null ? other$partType != null : !this$partType.equals(other$partType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GuiMultipart;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DisplayErrorsComponent $displayErrors = this.getDisplayErrors();
        result = result * 59 + ($displayErrors == null ? 43 : $displayErrors.hashCode());
        PartTarget $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        IPartContainer $partContainer = this.getPartContainer();
        result = result * 59 + ($partContainer == null ? 43 : $partContainer.hashCode());
        P $partType = this.getPartType();
        result = result * 59 + ($partType == null ? 43 : $partType.hashCode());
        return result;
    }

    public DisplayErrorsComponent getDisplayErrors() {
        return this.displayErrors;
    }

    public PartTarget getTarget() {
        return this.target;
    }

    public IPartContainer getPartContainer() {
        return this.partContainer;
    }

    public P getPartType() {
        return this.partType;
    }

    public String toString() {
        return "GuiMultipart(displayErrors=" + this.getDisplayErrors() + ", target=" + this.getTarget() + ", partContainer=" + this.getPartContainer() + ", partType=" + this.getPartType() + ")";
    }
}

