/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonImage;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonText;
import org.cyclops.cyclopscore.client.gui.container.ScrollingGuiContainer;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.client.gui.container.DisplayErrorsComponent;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipartAspects;
import org.cyclops.integrateddynamics.core.part.PartTypeConfigurable;

public abstract class GuiMultipartAspects<P extends IPartType<P, S> & IGuiContainerProvider, S extends IPartState<P>, A extends IAspect>
extends ScrollingGuiContainer {
    private static final Rectangle ITEM_POSITION = new Rectangle(8, 17, 18, 18);
    protected final DisplayErrorsComponent displayErrors = new DisplayErrorsComponent();
    private final PartTarget target;
    private final IPartContainer partContainer;
    private final P partType;
    private Map<IAspect, GuiButtonText> aspectPropertyButtons = Maps.newHashMap();

    public GuiMultipartAspects(ContainerMultipartAspects<P, S, A> container) {
        super(container);
        this.target = container.getTarget();
        this.partContainer = container.getPartContainer();
        this.partType = container.getPartType();
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        super.func_73866_w_();
        if (this.getPartType() instanceof PartTypeConfigurable && ((PartTypeConfigurable)this.getPartType()).hasSettings()) {
            this.field_146292_n.add(new GuiButtonImage(1, this.field_147003_i + 174, this.field_147009_r + 4, 15, 15, (IImage)Images.CONFIG_BOARD, -2, -3, true));
        }
        for (Map.Entry<IAspect, Integer> entry : ((ContainerMultipartAspects)this.getContainer()).getAspectPropertyButtons().entrySet()) {
            GuiButtonText button = new GuiButtonText(entry.getValue().intValue(), -20, -20, 10, 10, "+", true);
            this.aspectPropertyButtons.put(entry.getKey(), button);
            this.field_146292_n.add(button);
        }
    }

    public S getPartState() {
        return ((ContainerMultipartAspects)this.container).getPartState();
    }

    protected abstract String getNameId();

    public String getGuiTexture() {
        return (String)this.getContainer().getGuiProvider().getMod().getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + this.getNameId() + ".png";
    }

    protected float colorSmoothener(float color) {
        return 1.0f - (1.0f - color) / 4.0f;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        FontRenderer fontRenderer = this.field_146289_q;
        for (Map.Entry<IAspect, GuiButtonText> entry : this.aspectPropertyButtons.entrySet()) {
            entry.getValue().field_146128_h = -20;
            entry.getValue().field_146129_i = -20;
        }
        RenderHelpers.drawScaledCenteredString((FontRenderer)fontRenderer, (String)L10NHelpers.localize((String)this.getPartType().getUnlocalizedName()), (int)(this.field_147003_i + this.offsetX + 6), (int)(this.field_147009_r + this.offsetY + 10), (int)70, (int)Helpers.RGBToInt((int)0, (int)0, (int)0));
        ContainerMultipartAspects container = (ContainerMultipartAspects)this.getScrollingInventoryContainer();
        int aspectBoxHeight = container.getAspectBoxHeight();
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i)) continue;
            IAspect aspect = (IAspect)container.getVisibleElement(i);
            GlStateManager.func_179118_c();
            Triple rgb = Helpers.intToRGB((int)aspect.getValueType().getDisplayColor());
            GlStateManager.func_179131_c((float)this.colorSmoothener(((Float)rgb.getLeft()).floatValue()), (float)this.colorSmoothener(((Float)rgb.getMiddle()).floatValue()), (float)this.colorSmoothener(((Float)rgb.getRight()).floatValue()), (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(this.texture);
            this.func_73729_b(this.field_147003_i + this.offsetX + 9, this.field_147009_r + this.offsetY + 18 + aspectBoxHeight * i, 0, this.getBaseYSize(), 160, aspectBoxHeight - 1);
            String aspectName = L10NHelpers.localize((String)aspect.getUnlocalizedName());
            RenderHelpers.drawScaledCenteredString((FontRenderer)fontRenderer, (String)aspectName, (int)(this.field_147003_i + this.offsetX + 26), (int)(this.field_147009_r + this.offsetY + 25 + aspectBoxHeight * i), (int)60, (int)Helpers.RGBToInt((int)40, (int)40, (int)40));
            this.drawAdditionalElementInfo(container, i, aspect);
            if (!this.aspectPropertyButtons.containsKey(aspect)) continue;
            GuiButtonText button = this.aspectPropertyButtons.get(aspect);
            button.field_146128_h = this.field_147003_i + this.offsetX + 116;
            button.field_146129_i = this.field_147009_r + this.offsetY + 20 + aspectBoxHeight * i;
        }
    }

    protected abstract void drawAdditionalElementInfo(ContainerMultipartAspects<P, S, A> var1, int var2, A var3);

    protected Rectangle getElementPosition(ContainerMultipartAspects<P, S, A> container, int i, boolean absolute) {
        return new Rectangle(GuiMultipartAspects.ITEM_POSITION.x + this.offsetX + (absolute ? this.field_147003_i : 0), GuiMultipartAspects.ITEM_POSITION.y + container.getAspectBoxHeight() * i + this.offsetY + (absolute ? this.field_147009_r : 0), GuiMultipartAspects.ITEM_POSITION.width, GuiMultipartAspects.ITEM_POSITION.height);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        ContainerMultipartAspects container = (ContainerMultipartAspects)this.getScrollingInventoryContainer();
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i)) continue;
            if (this.isPointInRegion(this.getElementPosition(container, i, false), new Point(mouseX, mouseY))) {
                LinkedList lines = Lists.newLinkedList();
                ((IAspect)container.getVisibleElement(i)).loadTooltip(lines, true);
                this.drawTooltip(lines, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            }
            this.drawAdditionalElementInfoForeground(container, i, (IAspect)container.getVisibleElement(i), mouseX, mouseY);
            IAspect aspect = (IAspect)container.getVisibleElement(i);
            if (!this.aspectPropertyButtons.containsKey(aspect)) continue;
            GuiButtonText button = this.aspectPropertyButtons.get(aspect);
            int x = button.field_146128_h - this.field_147003_i;
            int y = button.field_146129_i - this.field_147009_r;
            if (!this.func_146978_c(x, y, button.field_146120_f, button.field_146121_g, mouseX, mouseY)) continue;
            LinkedList lines = Lists.newLinkedList();
            lines.add(TextFormatting.WHITE + L10NHelpers.localize((String)"gui.integrateddynamics.part.properties"));
            for (IAspectPropertyTypeInstance property : aspect.getPropertyTypes()) {
                lines.add("-" + TextFormatting.YELLOW + L10NHelpers.localize((String)property.getUnlocalizedName()));
            }
            this.drawTooltip(lines, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected abstract void drawAdditionalElementInfoForeground(ContainerMultipartAspects<P, S, A> var1, int var2, A var3, int var4, int var5);

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuiMultipartAspects)) {
            return false;
        }
        GuiMultipartAspects other = (GuiMultipartAspects)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DisplayErrorsComponent this$displayErrors = this.getDisplayErrors();
        DisplayErrorsComponent other$displayErrors = other.getDisplayErrors();
        if (this$displayErrors == null ? other$displayErrors != null : !this$displayErrors.equals(other$displayErrors)) {
            return false;
        }
        PartTarget this$target = this.getTarget();
        PartTarget other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        IPartContainer this$partContainer = this.getPartContainer();
        IPartContainer other$partContainer = other.getPartContainer();
        if (this$partContainer == null ? other$partContainer != null : !this$partContainer.equals(other$partContainer)) {
            return false;
        }
        P this$partType = this.getPartType();
        P other$partType = other.getPartType();
        if (this$partType == null ? other$partType != null : !this$partType.equals(other$partType)) {
            return false;
        }
        Map<IAspect, GuiButtonText> this$aspectPropertyButtons = this.getAspectPropertyButtons();
        Map<IAspect, GuiButtonText> other$aspectPropertyButtons = other.getAspectPropertyButtons();
        return !(this$aspectPropertyButtons == null ? other$aspectPropertyButtons != null : !((Object)this$aspectPropertyButtons).equals(other$aspectPropertyButtons));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GuiMultipartAspects;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DisplayErrorsComponent $displayErrors = this.getDisplayErrors();
        result = result * 59 + ($displayErrors == null ? 43 : $displayErrors.hashCode());
        PartTarget $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        IPartContainer $partContainer = this.getPartContainer();
        result = result * 59 + ($partContainer == null ? 43 : $partContainer.hashCode());
        P $partType = this.getPartType();
        result = result * 59 + ($partType == null ? 43 : $partType.hashCode());
        Map<IAspect, GuiButtonText> $aspectPropertyButtons = this.getAspectPropertyButtons();
        result = result * 59 + ($aspectPropertyButtons == null ? 43 : ((Object)$aspectPropertyButtons).hashCode());
        return result;
    }

    public DisplayErrorsComponent getDisplayErrors() {
        return this.displayErrors;
    }

    public PartTarget getTarget() {
        return this.target;
    }

    public IPartContainer getPartContainer() {
        return this.partContainer;
    }

    public P getPartType() {
        return this.partType;
    }

    public Map<IAspect, GuiButtonText> getAspectPropertyButtons() {
        return this.aspectPropertyButtons;
    }

    public void setAspectPropertyButtons(Map<IAspect, GuiButtonText> aspectPropertyButtons) {
        this.aspectPropertyButtons = aspectPropertyButtons;
    }

    public String toString() {
        return "GuiMultipartAspects(displayErrors=" + this.getDisplayErrors() + ", target=" + this.getTarget() + ", partContainer=" + this.getPartContainer() + ", partType=" + this.getPartType() + ", aspectPropertyButtons=" + this.getAspectPropertyButtons() + ")";
    }
}

