/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.base.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueOptionalBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueObjectTypeItemStack
extends ValueObjectTypeBase<ValueItemStack>
implements IValueTypeNamed<ValueItemStack>,
IValueTypeNullable<ValueItemStack> {
    public ValueObjectTypeItemStack() {
        super("itemstack");
    }

    @Override
    public ValueItemStack getDefault() {
        return ValueItemStack.of(null);
    }

    @Override
    public String toCompactString(ValueItemStack value) {
        Optional itemStack = value.getRawValue();
        return itemStack.isPresent() ? ((ItemStack)itemStack.get()).func_82833_r() : "";
    }

    @Override
    public String serialize(ValueItemStack value) {
        NBTTagCompound tag = new NBTTagCompound();
        Optional itemStack = value.getRawValue();
        if (itemStack.isPresent()) {
            ((ItemStack)itemStack.get()).func_77955_b(tag);
        }
        return tag.toString();
    }

    @Override
    public ValueItemStack deserialize(String value) {
        try {
            NBTTagCompound tag = JsonToNBT.func_180713_a((String)value);
            ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)tag);
            return ValueItemStack.of(itemStack);
        }
        catch (NBTException e) {
            return null;
        }
    }

    @Override
    public String getName(ValueItemStack a) {
        return this.toCompactString(a);
    }

    @Override
    public boolean isNull(ValueItemStack a) {
        return !a.getRawValue().isPresent();
    }

    public static class ValueItemStack
    extends ValueOptionalBase<ItemStack> {
        private ValueItemStack(ItemStack itemStack) {
            super(ValueTypes.OBJECT_ITEMSTACK, itemStack);
        }

        public static ValueItemStack of(ItemStack itemStack) {
            return new ValueItemStack(itemStack);
        }

        @Override
        protected boolean isEqual(ItemStack a, ItemStack b) {
            return ItemStackHelpers.areItemStacksIdentical((ItemStack)a, (ItemStack)b);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeItemStack.ValueItemStack()";
        }
    }
}

