/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeOperator
extends ValueTypeBase<ValueOperator> {
    private static final String SIGNATURE_LINK = "->";

    public ValueTypeOperator() {
        super("operator", Helpers.RGBToInt((int)43, (int)231, (int)47), TextFormatting.DARK_GREEN.toString());
    }

    @Override
    public ValueOperator getDefault() {
        return ValueOperator.of(Operators.GENERAL_IDENTITY);
    }

    @Override
    public String toCompactString(ValueOperator value) {
        return value.getRawValue().getLocalizedNameFull();
    }

    @Override
    public String serialize(ValueOperator value) {
        return value.getRawValue().getUniqueName();
    }

    @Override
    public ValueOperator deserialize(String value) {
        IOperator operator = Operators.REGISTRY.getOperator(value);
        if (operator != null) {
            return ValueOperator.of(operator);
        }
        throw new IllegalArgumentException(String.format("Value \"%s\" could not be parsed to an operator.", value));
    }

    @Override
    public void loadTooltip(List<String> lines, boolean appendOptionalInfo, @Nullable ValueOperator value) {
        super.loadTooltip(lines, appendOptionalInfo, value);
        if (value != null) {
            lines.add(L10NHelpers.localize((String)"valuetype.integrateddynamics.operator.tooltip.signature", (Object[])new Object[]{ValueTypeOperator.getSignature(value.getRawValue())}));
        }
    }

    @Override
    public boolean hasDefaultLogicProgrammerElement() {
        return false;
    }

    public static String getSignature(IOperator operator) {
        return StringUtils.join(ValueTypeOperator.getSignatureLines(operator, false), (String)" ");
    }

    public static String getSignature(IValueType[] inputTypes, IValueType outputType) {
        return StringUtils.join(ValueTypeOperator.getSignatureLines(inputTypes, outputType, false), (String)" ");
    }

    protected static StringBuilder switchSignatureLineContext(List<String> lines, StringBuilder sb) {
        lines.add(sb.toString());
        return new StringBuilder();
    }

    public static List<String> getSignatureLines(IValueType[] inputTypes, IValueType outputType, boolean indent) {
        ArrayList lines = Lists.newArrayList();
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean first = true;
        for (IValueType inputType : inputTypes) {
            if (first) {
                first = false;
            } else {
                sb = ValueTypeOperator.switchSignatureLineContext(lines, sb);
                sb.append((indent ? "  " : "") + SIGNATURE_LINK + " ");
            }
            sb.append(inputType.getDisplayColorFormat()).append(L10NHelpers.localize((String)inputType.getUnlocalizedName())).append(TextFormatting.RESET);
        }
        sb.append(")");
        sb = ValueTypeOperator.switchSignatureLineContext(lines, sb);
        sb.append("-> ").append(outputType.getDisplayColorFormat()).append(L10NHelpers.localize((String)outputType.getUnlocalizedName())).append(TextFormatting.RESET);
        ValueTypeOperator.switchSignatureLineContext(lines, sb);
        return lines;
    }

    public static List<String> getSignatureLines(IOperator operator, boolean indent) {
        return ValueTypeOperator.getSignatureLines(operator.getInputTypes(), operator.getOutputType(), indent);
    }

    public static class ValueOperator
    extends ValueBase {
        private final IOperator value;

        private ValueOperator(IOperator value) {
            super(ValueTypes.OPERATOR);
            this.value = value;
        }

        public static ValueOperator of(IOperator value) {
            return new ValueOperator(value);
        }

        public IOperator getRawValue() {
            return this.value;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof ValueOperator && ((ValueOperator)o).value == this.value;
        }

        @Override
        public String toString() {
            return "ValueTypeOperator.ValueOperator(value=" + this.value + ")";
        }
    }
}

