/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.cyclopscore.item.ItemBlockNBT;
import org.cyclops.integrateddynamics.api.block.IEnergyContainer;
import org.cyclops.integrateddynamics.api.block.IEnergyContainerBlock;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryConfig;

@Optional.Interface(iface="cofh.api.energy.IEnergyContainerItem", modid="CoFHAPI", striprefs=true)
public class ItemBlockEnergyContainer
extends ItemBlockNBT
implements IEnergyContainer,
IEnergyContainerItem {
    private IEnergyContainerBlock block;

    public ItemBlockEnergyContainer(Block block) {
        super(block);
        this.func_77627_a(false);
        this.block = (IEnergyContainerBlock)block;
    }

    public IEnergyContainerBlock get() {
        return this.block;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        int amount = this.getStoredEnergy(itemStack);
        int capacity = this.getMaxStoredEnergy(itemStack);
        String line = String.format("%,d", amount) + " / " + String.format("%,d", capacity) + " " + L10NHelpers.localize((String)"general.integrateddynamics.energyUnit.name");
        list.add(IInformationProvider.ITEM_PREFIX + line);
    }

    @Override
    public int getStoredEnergy(ItemStack itemStack) {
        NBTTagCompound tag = ItemStackHelpers.getSafeTagCompound((ItemStack)itemStack);
        return tag.func_74762_e(this.get().getEneryContainerNBTName());
    }

    @Override
    public int getMaxStoredEnergy(ItemStack itemStack) {
        return BlockEnergyBatteryConfig.capacity;
    }

    protected void setEnergy(ItemStack itemStack, int energy) {
        NBTTagCompound tag = ItemStackHelpers.getSafeTagCompound((ItemStack)itemStack);
        tag.func_74768_a(this.get().getEneryContainerNBTName(), energy);
    }

    @Override
    public int addEnergy(ItemStack itemStack, int energy, boolean simulate) {
        int stored = this.getStoredEnergy(itemStack);
        int newEnergy = Math.min(stored + energy, this.getMaxStoredEnergy(itemStack));
        if (!simulate) {
            this.setEnergy(itemStack, newEnergy);
        }
        return newEnergy - stored;
    }

    @Override
    public int consume(ItemStack itemStack, int energy, boolean simulate) {
        int stored = this.getStoredEnergy(itemStack);
        int newEnergy = Math.max(stored - energy, 0);
        if (!simulate) {
            this.setEnergy(itemStack, newEnergy);
        }
        return stored - newEnergy;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        double amount = this.getStoredEnergy(itemStack);
        double capacity = this.getMaxStoredEnergy(itemStack);
        return (capacity - amount) / capacity;
    }

    @Optional.Method(modid="CoFHAPI")
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return this.addEnergy(container, maxReceive, simulate);
    }

    @Optional.Method(modid="CoFHAPI")
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return this.consume(container, maxExtract, simulate);
    }

    @Optional.Method(modid="CoFHAPI")
    public int getEnergyStored(ItemStack container) {
        return this.getStoredEnergy(container);
    }

    @Optional.Method(modid="CoFHAPI")
    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStoredEnergy(container);
    }
}

