/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.network.IEventListenableNetworkElement;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.api.network.event.INetworkEventBus;
import org.cyclops.integrateddynamics.api.path.ICablePathElement;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.network.diagnostics.NetworkDiagnostics;
import org.cyclops.integrateddynamics.core.network.event.NetworkElementAddEvent;
import org.cyclops.integrateddynamics.core.network.event.NetworkElementRemoveEvent;
import org.cyclops.integrateddynamics.core.network.event.NetworkEventBus;
import org.cyclops.integrateddynamics.core.path.Cluster;
import org.cyclops.integrateddynamics.core.persist.world.NetworkWorldStorage;

public class Network<N extends INetwork<N>>
implements INetwork<N> {
    private Cluster<ICablePathElement> baseCluster;
    private final INetworkEventBus<N> eventBus = new NetworkEventBus();
    private final TreeSet<INetworkElement<N>> elements = Sets.newTreeSet();
    private TreeSet<INetworkElement<N>> updateableElements = null;
    private TreeMap<INetworkElement<N>, Integer> updateableElementsTicks = null;
    private Map<INetworkElement<N>, Long> lastSecondDurations = Maps.newHashMap();
    private volatile boolean changed = false;
    private volatile boolean killed = false;
    private boolean crashed = false;

    public Network() {
        this.baseCluster = new Cluster();
        this.onConstruct();
    }

    public Network(Cluster<ICablePathElement> cables) {
        this.baseCluster = cables;
        this.onConstruct();
        this.deriveNetworkElements(this.baseCluster);
    }

    protected void onConstruct() {
    }

    protected N getMaterializedThis() {
        return (N)this;
    }

    private void deriveNetworkElements(Cluster<ICablePathElement> cables) {
        if (!this.killIfEmpty()) {
            for (ICablePathElement cable : cables) {
                INetworkCarrier networkCarrier;
                BlockPos pos;
                World world = cable.getPosition().getWorld();
                INetworkElementProvider networkElementProvider = CableHelpers.getInterface((IBlockAccess)world, pos = cable.getPosition().getBlockPos(), INetworkElementProvider.class);
                if (networkElementProvider != null) {
                    for (INetworkElement element : networkElementProvider.createNetworkElements(world, pos)) {
                        this.addNetworkElement(element, true);
                    }
                }
                if ((networkCarrier = CableHelpers.getInterface((IBlockAccess)world, pos, INetworkCarrier.class)) == null) continue;
                Object network = networkCarrier.getNetwork(world, pos);
                if (network != null) {
                    network.removeCable((ICable)((Object)networkCarrier), cable);
                }
                networkCarrier.resetCurrentNetwork(world, pos);
                networkCarrier.setNetwork(this.getMaterializedThis(), world, pos);
            }
            this.onNetworkChanged();
        }
    }

    @Override
    public INetworkEventBus<N> getEventBus() {
        return this.eventBus;
    }

    public void initialize() {
        this.initialize(false);
    }

    public static <N extends INetwork<N>> boolean areNetworksEqual(Network<N> networkA, Network<N> networkB) {
        return networkA.elements.containsAll(networkB.elements) && networkA.elements.size() == networkB.elements.size();
    }

    public boolean equals(Object object) {
        return object instanceof Network && Network.areNetworksEqual(this, (Network)object);
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("baseCluster", (NBTBase)this.baseCluster.toNBT());
        tag.func_74757_a("crashed", this.crashed);
        return tag;
    }

    public void fromNBT(NBTTagCompound tag) {
        this.baseCluster.fromNBT(tag.func_74775_l("baseCluster"));
        this.crashed = tag.func_74767_n("crashed");
        this.deriveNetworkElements(this.baseCluster);
        this.initialize(true);
    }

    @Override
    public boolean addNetworkElement(INetworkElement<N> element, boolean networkPreinit) {
        if (this.getEventBus().postCancelable(new NetworkElementAddEvent.Pre<N>(this.getMaterializedThis(), element))) {
            IEventListenableNetworkElement listenableElement;
            Object listener;
            this.elements.add(element);
            if (!element.onNetworkAddition(this.getMaterializedThis())) {
                this.elements.remove(element);
                return false;
            }
            if (!networkPreinit) {
                this.addNetworkElementUpdateable(element);
            }
            if (element instanceof IEventListenableNetworkElement && (listener = (listenableElement = (IEventListenableNetworkElement)element).getNetworkEventListener()) != null && listener.hasEventSubscriptions()) {
                for (Class eventType : listener.getSubscribedEvents()) {
                    this.getEventBus().register(listenableElement, eventType);
                }
            }
            this.getEventBus().post(new NetworkElementAddEvent.Post<N>(this.getMaterializedThis(), element));
            this.onNetworkChanged();
            return true;
        }
        return false;
    }

    @Override
    public void addNetworkElementUpdateable(INetworkElement<N> element) {
        if (element.isUpdate()) {
            this.updateableElements.add(element);
            this.updateableElementsTicks.put(element, 0);
        }
    }

    @Override
    public boolean removeNetworkElementPre(INetworkElement<N> element) {
        return this.getEventBus().postCancelable(new NetworkElementRemoveEvent.Pre<N>(this.getMaterializedThis(), element));
    }

    @Override
    public void removeNetworkElementPost(INetworkElement<N> element) {
        IEventListenableNetworkElement listenableElement;
        Object listener;
        if (element instanceof IEventListenableNetworkElement && (listener = (listenableElement = (IEventListenableNetworkElement)element).getNetworkEventListener()) != null && listener.hasEventSubscriptions()) {
            this.getEventBus().unregister(listenableElement);
        }
        element.beforeNetworkKill(this.getMaterializedThis());
        element.onNetworkRemoval(this.getMaterializedThis());
        this.elements.remove(element);
        this.removeNetworkElementUpdateable((INetworkElement)element);
        this.getEventBus().post(new NetworkElementRemoveEvent.Post<N>(this.getMaterializedThis(), element));
        this.onNetworkChanged();
    }

    @Override
    public void removeNetworkElementUpdateable(INetworkElement element) {
        this.updateableElements.remove(element);
        this.updateableElementsTicks.remove(element);
    }

    protected void initialize(boolean silent) {
        this.updateableElements = Sets.newTreeSet();
        this.updateableElementsTicks = Maps.newTreeMap();
        for (INetworkElement<N> element : this.elements) {
            this.addNetworkElementUpdateable(element);
            if (!silent) {
                element.afterNetworkAlive(this.getMaterializedThis());
            }
            element.afterNetworkReAlive(this.getMaterializedThis());
        }
    }

    @Override
    public void kill() {
        for (INetworkElement<N> element : this.elements) {
            element.beforeNetworkKill(this.getMaterializedThis());
        }
        this.killed = true;
    }

    @Override
    public boolean killIfEmpty() {
        if (this.baseCluster.isEmpty()) {
            this.kill();
            this.onNetworkChanged();
            return true;
        }
        return false;
    }

    protected boolean canUpdate(INetworkElement<N> element) {
        return true;
    }

    protected void postUpdate(INetworkElement<N> element) {
    }

    protected void onSkipUpdate(INetworkElement<N> element) {
    }

    @Override
    public final void update() {
        this.changed = false;
        if (this.killIfEmpty() || this.killed) {
            NetworkWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).removeInvalidatedNetwork(this);
        } else {
            this.onUpdate();
            boolean isBeingDiagnozed = NetworkDiagnostics.getInstance().isBeingDiagnozed();
            if (!isBeingDiagnozed && !this.lastSecondDurations.isEmpty()) {
                this.lastSecondDurations.clear();
            }
            for (INetworkElement<N> element : this.updateableElements) {
                long startTime = 0L;
                if (isBeingDiagnozed) {
                    startTime = System.nanoTime();
                }
                if (this.canUpdate(element)) {
                    if (this.updateableElementsTicks.get(element) <= 0) {
                        this.updateableElementsTicks.put(element, element.getUpdateInterval());
                        element.update(this.getMaterializedThis());
                        this.postUpdate(element);
                    }
                } else {
                    this.onSkipUpdate(element);
                }
                this.updateableElementsTicks.put(element, this.updateableElementsTicks.get(element) - 1);
                if (!isBeingDiagnozed) continue;
                long duration = System.nanoTime() - startTime;
                duration /= 1000L;
                Long lastDuration = this.lastSecondDurations.get(element);
                if (lastDuration != null) {
                    duration += lastDuration.longValue();
                }
                this.lastSecondDurations.put(element, duration);
            }
        }
    }

    protected void onUpdate() {
    }

    @Override
    public boolean removeCable(ICable cable, ICablePathElement cablePathElement) {
        if (this.baseCluster.remove(cablePathElement)) {
            if (cable instanceof INetworkElementProvider) {
                Collection networkElements = ((INetworkElementProvider)((Object)cable)).createNetworkElements(cablePathElement.getPosition().getWorld(), cablePathElement.getPosition().getBlockPos());
                for (INetworkElement networkElement : networkElements) {
                    if (this.removeNetworkElementPre(networkElement)) continue;
                    return false;
                }
                for (INetworkElement networkElement : networkElements) {
                    this.removeNetworkElementPost(networkElement);
                }
                this.onNetworkChanged();
                return true;
            }
        } else {
            Thread.dumpStack();
            IntegratedDynamics.clog(Level.WARN, "Tried to remove a cable from a network it was not present in.");
            System.out.println("Cluster: " + this.baseCluster);
            System.out.println("Tried removing element: " + cablePathElement);
        }
        return false;
    }

    @Override
    public void afterServerLoad() {
    }

    @Override
    public void beforeServerStop() {
    }

    @Override
    public Set<INetworkElement<N>> getElements() {
        return this.elements;
    }

    @Override
    public boolean isKilled() {
        return this.killed;
    }

    protected void onNetworkChanged() {
        this.changed = true;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public int getCablesCount() {
        return this.baseCluster.size();
    }

    @Override
    public long getLastSecondDuration(INetworkElement<N> networkElement) {
        Long duration = this.lastSecondDurations.get(networkElement);
        return duration == null ? 0L : duration;
    }

    @Override
    public void resetLastSecondDurations() {
        this.lastSecondDurations.clear();
    }

    @Override
    public boolean isCrashed() {
        return this.crashed;
    }

    @Override
    public void setCrashed(boolean crashed) {
        this.crashed = crashed;
    }
}

