/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import java.beans.ConstructorProperties;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.core.network.ConsumingNetworkElementBase;
import org.cyclops.integrateddynamics.core.tileentity.TileCableConnectableInventory;

public abstract class TileNetworkElement<T extends TileCableConnectableInventory>
extends ConsumingNetworkElementBase<IPartNetwork> {
    private final DimPos pos;

    protected abstract Class<T> getTileClass();

    protected T getTile() {
        return (T)((TileCableConnectableInventory)TileHelpers.getSafeTile((IBlockAccess)this.getPos().getWorld(), (BlockPos)this.getPos().getBlockPos(), this.getTileClass()));
    }

    @Override
    public void addDrops(List<ItemStack> itemStacks, boolean dropMainElement) {
        T tile = this.getTile();
        if (tile != null) {
            InventoryHelper.func_180175_a((World)this.getPos().getWorld(), (BlockPos)this.getPos().getBlockPos(), (IInventory)tile.getInventory());
        }
    }

    @Override
    public int compareTo(INetworkElement o) {
        if (o instanceof TileNetworkElement) {
            return this.getPos().compareTo(((TileNetworkElement)o).getPos());
        }
        return Integer.compare(this.hashCode(), o.hashCode());
    }

    @Override
    public void afterNetworkReAlive(IPartNetwork network) {
        super.afterNetworkReAlive(network);
        ((TileCableConnectableInventory)this.getTile()).afterNetworkReAlive();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TileNetworkElement)) {
            return false;
        }
        TileNetworkElement other = (TileNetworkElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DimPos this$pos = this.getPos();
        DimPos other$pos = other.getPos();
        return !(this$pos == null ? other$pos != null : !this$pos.equals(other$pos));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TileNetworkElement;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DimPos $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        return result;
    }

    @ConstructorProperties(value={"pos"})
    public TileNetworkElement(DimPos pos) {
        this.pos = pos;
    }

    public DimPos getPos() {
        return this.pos;
    }

    @Override
    public String toString() {
        return "TileNetworkElement(pos=" + this.getPos() + ")";
    }
}

