/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network.diagnostics;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.network.diagnostics.NetworkDiagnosticsPartOverlayRenderer;
import org.cyclops.integrateddynamics.core.network.diagnostics.RawNetworkData;
import org.cyclops.integrateddynamics.core.network.diagnostics.RawPartData;
import org.cyclops.integrateddynamics.network.packet.NetworkDiagnosticsSubscribePacket;
import org.cyclops.integrateddynamics.network.packet.PlayerTeleportPacket;

public class GuiNetworkDiagnostics
extends JFrame {
    private static GuiNetworkDiagnostics gui = null;
    private static JTable table = null;
    private static Vector<String> columnNames = new Vector();
    private static Vector<Vector<Object>> data = new Vector();
    private static DefaultTableModel model;
    private static Multimap<Integer, ObservablePartData> networkData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setNetworkData(int id, RawNetworkData rawNetworkData) {
        Multimap<Integer, ObservablePartData> multimap = networkData;
        synchronized (multimap) {
            Collection previous = networkData.removeAll((Object)id);
            HashSet previousPositionsWithRender = Sets.newHashSet();
            for (ObservablePartData partData : previous) {
                PartPos pos = partData.toPartPos();
                if (pos == null || !NetworkDiagnosticsPartOverlayRenderer.getInstance().hasPartPos(pos)) continue;
                previousPositionsWithRender.add(pos);
            }
            if (rawNetworkData != null) {
                ArrayList parts = Lists.newArrayList();
                for (RawPartData rawPartData : rawNetworkData.getParts()) {
                    ObservablePartData partData = new ObservablePartData(rawNetworkData.getId(), rawNetworkData.getCables(), rawPartData.getDimension(), rawPartData.getPos(), rawPartData.getSide(), rawPartData.getName(), rawPartData.getLastTickDuration());
                    parts.add(partData);
                    PartPos pos = partData.toPartPos();
                    if (pos == null) continue;
                    previousPositionsWithRender.remove(pos);
                }
                for (PartPos partPos : previousPositionsWithRender) {
                    NetworkDiagnosticsPartOverlayRenderer.getInstance().removePos(partPos);
                }
                networkData.putAll((Object)id, (Iterable)parts);
            }
        }
        if (gui != null) {
            gui.updateTable();
        }
    }

    public static void clearNetworkData() {
        networkData.clear();
    }

    public static void start() {
        if (gui == null) {
            gui = new GuiNetworkDiagnostics();
            gui.setTitle(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.title"));
            gui.updateTable();
            gui.setSize(750, 500);
            gui.setDefaultCloseOperation(1);
            gui.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    GuiNetworkDiagnostics.onCloseGui();
                    super.windowClosing(e);
                }
            });
            gui.setLocationRelativeTo(null);
        }
        gui.setVisible(true);
    }

    protected void updateTable() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Multimap multimap = networkData;
                    synchronized (multimap) {
                        columnNames.clear();
                        columnNames.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.network"));
                        columnNames.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.cables"));
                        columnNames.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.part"));
                        columnNames.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.ticktime"));
                        columnNames.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.dimension"));
                        columnNames.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.position"));
                        columnNames.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.side"));
                        columnNames.addElement("_id");
                        data.clear();
                        int i = 0;
                        for (ObservablePartData observablePartData : networkData.values()) {
                            Vector<Object> row = new Vector<Object>();
                            row.add(observablePartData.getNetworkId());
                            row.add(observablePartData.getNetworkCables());
                            row.add(observablePartData.getName());
                            row.add(observablePartData.getLastTickDuration());
                            row.add(observablePartData.getDimension());
                            BlockPos pos = observablePartData.getPos();
                            row.add(String.format("%s / %s / %s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                            row.add(observablePartData.getSide().name());
                            row.add(i++);
                            data.addElement(row);
                        }
                        if (table == null) {
                            table = new JTable();
                            model = new DefaultTableModel(data, columnNames){

                                public Class getColumnClass(int column) {
                                    if (column == 0 || column == 1 || column == 4) {
                                        return Integer.class;
                                    }
                                    if (column == 3) {
                                        return Long.class;
                                    }
                                    return String.class;
                                }
                            };
                            table.setModel(model);
                            table.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

                                @Override
                                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                                    Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                                    ObservablePartData partData = GuiNetworkDiagnostics.getPartDataFromRow(row);
                                    if (partData != null && NetworkDiagnosticsPartOverlayRenderer.getInstance().hasPartPos(partData.toPartPos())) {
                                        c.setBackground(Color.CYAN);
                                    } else {
                                        c.setBackground(isSelected ? Color.BLUE : Color.WHITE);
                                    }
                                    return c;
                                }
                            });
                            table.getColumnModel().removeColumn(table.getColumn("_id"));
                            table.setAutoCreateRowSorter(true);
                            table.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mouseClicked(MouseEvent e) {
                                    JTable target;
                                    int row;
                                    ObservablePartData partData;
                                    super.mouseClicked(e);
                                    if (e.getClickCount() == 1 && (partData = GuiNetworkDiagnostics.getPartDataFromRow(row = (target = (JTable)e.getSource()).rowAtPoint(e.getPoint()))) != null) {
                                        PartPos pos = partData.toPartPos();
                                        if (e.getButton() == 1) {
                                            if (NetworkDiagnosticsPartOverlayRenderer.getInstance().hasPartPos(pos)) {
                                                NetworkDiagnosticsPartOverlayRenderer.getInstance().removePos(pos);
                                            } else {
                                                NetworkDiagnosticsPartOverlayRenderer.getInstance().addPos(pos);
                                            }
                                        } else if (e.getButton() == 3) {
                                            BlockPos blockPos = pos.getPos().getBlockPos().func_177972_a(pos.getSide());
                                            float yaw = pos.getSide().func_176734_d().func_185119_l();
                                            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new PlayerTeleportPacket(pos.getPos().getWorld().field_73011_w.getDimension(), blockPos.func_177958_n(), blockPos.func_177956_o() - 1, blockPos.func_177952_p(), yaw, 0.0f));
                                        }
                                    }
                                }
                            });
                            GuiNetworkDiagnostics.this.add(new JScrollPane(table));
                            GuiNetworkDiagnostics.this.pack();
                        } else {
                            table.getRowSorter().allRowsChanged();
                            model.fireTableDataChanged();
                        }
                        GuiNetworkDiagnostics.this.repaint();
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ObservablePartData getPartDataFromRow(int row) {
        Object[] data;
        if (row < 0) {
            return null;
        }
        Multimap<Integer, ObservablePartData> multimap = networkData;
        synchronized (multimap) {
            data = networkData.values().toArray();
        }
        int internalId = (Integer)table.getModel().getValueAt(table.convertRowIndexToModel(row), 7);
        if (internalId < data.length) {
            return (ObservablePartData)data[internalId];
        }
        return null;
    }

    protected static void onCloseGui() {
        IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)NetworkDiagnosticsSubscribePacket.unsubscribe());
        NetworkDiagnosticsPartOverlayRenderer.getInstance().clearPositions();
    }

    static {
        networkData = ArrayListMultimap.create();
    }

    public static class ObservablePartData {
        private final int networkId;
        private final int networkCables;
        private final int dimension;
        private final BlockPos pos;
        private final EnumFacing side;
        private final String name;
        private final long lastTickDuration;

        public PartPos toPartPos() {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (this.getDimension() == world.field_73011_w.getDimension()) {
                return PartPos.of(DimPos.of((World)world, (BlockPos)this.getPos()), this.getSide());
            }
            return null;
        }

        @ConstructorProperties(value={"networkId", "networkCables", "dimension", "pos", "side", "name", "lastTickDuration"})
        public ObservablePartData(int networkId, int networkCables, int dimension, BlockPos pos, EnumFacing side, String name, long lastTickDuration) {
            this.networkId = networkId;
            this.networkCables = networkCables;
            this.dimension = dimension;
            this.pos = pos;
            this.side = side;
            this.name = name;
            this.lastTickDuration = lastTickDuration;
        }

        public int getNetworkId() {
            return this.networkId;
        }

        public int getNetworkCables() {
            return this.networkCables;
        }

        public int getDimension() {
            return this.dimension;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public EnumFacing getSide() {
            return this.side;
        }

        public String getName() {
            return this.name;
        }

        public long getLastTickDuration() {
            return this.lastTickDuration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ObservablePartData)) {
                return false;
            }
            ObservablePartData other = (ObservablePartData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getNetworkId() != other.getNetworkId()) {
                return false;
            }
            if (this.getNetworkCables() != other.getNetworkCables()) {
                return false;
            }
            if (this.getDimension() != other.getDimension()) {
                return false;
            }
            BlockPos this$pos = this.getPos();
            BlockPos other$pos = other.getPos();
            if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
                return false;
            }
            EnumFacing this$side = this.getSide();
            EnumFacing other$side = other.getSide();
            if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return this.getLastTickDuration() == other.getLastTickDuration();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ObservablePartData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getNetworkId();
            result = result * 59 + this.getNetworkCables();
            result = result * 59 + this.getDimension();
            BlockPos $pos = this.getPos();
            result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
            EnumFacing $side = this.getSide();
            result = result * 59 + ($side == null ? 43 : $side.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            long $lastTickDuration = this.getLastTickDuration();
            result = result * 59 + (int)($lastTickDuration >>> 32 ^ $lastTickDuration);
            return result;
        }

        public String toString() {
            return "GuiNetworkDiagnostics.ObservablePartData(networkId=" + this.getNetworkId() + ", networkCables=" + this.getNetworkCables() + ", dimension=" + this.getDimension() + ", pos=" + this.getPos() + ", side=" + this.getSide() + ", name=" + this.getName() + ", lastTickDuration=" + this.getLastTickDuration() + ")";
        }
    }
}

