/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import java.util.Set;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.core.part.PartTypeConfigurable;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public abstract class PartTypeAspects<P extends IPartType<P, S>, S extends IPartState<P>>
extends PartTypeConfigurable<P, S> {
    public PartTypeAspects(String name, IPartType.RenderPosition renderPosition) {
        super(name, renderPosition);
    }

    public Set<IAspect> getAspects() {
        return Aspects.REGISTRY.getAspects(this);
    }

    @Override
    public boolean isUpdate(S state) {
        return !this.getAspects().isEmpty();
    }

    @Override
    public void update(IPartNetwork network, PartTarget target, S state) {
        super.update(network, target, state);
        for (IAspect aspect : this.getAspects()) {
            aspect.update(network, this, target, state);
        }
    }

    @Override
    public int getConsumptionRate(S state) {
        return 1;
    }
}

