/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.inventory.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integrateddynamics.api.tileentity.ITileCableNetwork;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipartAspects;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;

public class ContainerPartWriter<P extends IPartTypeWriter<P, S> & IGuiContainerProvider, S extends IPartStateWriter<P>>
extends ContainerMultipartAspects<P, S, IAspectWrite> {
    public static final int ASPECT_BOX_HEIGHT = 18;
    private static final int PAGE_SIZE = 6;
    private static final int SLOT_X = 131;
    private static final int SLOT_Y = 18;
    private final int valueId;
    private final int colorId;

    public ContainerPartWriter(EntityPlayer player, PartTarget partTarget, IPartContainer partContainer, P partType) {
        super(player, partTarget, partContainer, partType, partType.getWriteAspects());
        for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.func_75146_a((Slot)new SlotVariable(this.inputSlots, i, 131, 18 + this.getAspectBoxHeight() * i));
            this.disableSlot(i);
        }
        this.addPlayerInventory(player.field_71071_by, 9, 140);
        this.valueId = this.getNextValueId();
        this.colorId = this.getNextValueId();
    }

    @Override
    public int getAspectBoxHeight() {
        return 18;
    }

    @Override
    public int getPageSize() {
        return 6;
    }

    @Override
    protected void enableSlot(int slotIndex, int row) {
        Slot slot = this.func_75139_a(slotIndex);
        slot.field_75223_e = 131;
        slot.field_75221_f = 18 + 18 * row;
    }

    @Override
    protected IInventory constructInputSlotsInventory() {
        SimpleInventory inventory = ((IPartStateWriter)this.getPartState()).getInventory();
        inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        return inventory;
    }

    public void onDirty() {
        if (!MinecraftHelpers.isClientSide()) {
            ((IPartTypeWriter)this.getPartType()).updateActivation(this.getTarget(), (IPartStateWriter)this.getPartState());
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!MinecraftHelpers.isClientSide()) {
            String writeValue = "";
            int writeValueColor = 0;
            if (this.getPartContainer() instanceof ITileCableNetwork && ((IPartStateWriter)this.getPartState()).hasVariable()) {
                IPartNetwork network = ((ITileCableNetwork)((Object)this.getPartContainer())).getNetwork();
                if (network != null) {
                    IVariable variable = ((IPartStateWriter)this.getPartState()).getVariable(network);
                    if (variable != null) {
                        try {
                            Object value = variable.getValue();
                            writeValue = value.getType().toCompactString(value);
                            writeValueColor = variable.getType().getDisplayColor();
                        }
                        catch (EvaluationException e) {
                            writeValue = "ERROR";
                            writeValueColor = Helpers.RGBToInt((int)255, (int)0, (int)0);
                        }
                    }
                } else {
                    writeValue = "NETWORK CORRUPTED!";
                    writeValueColor = Helpers.RGBToInt((int)255, (int)100, (int)0);
                }
            } else {
                writeValue = "";
            }
            this.setWriteValue(writeValue, writeValueColor);
        }
    }

    public void setWriteValue(String writeValue, int writeColor) {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.valueId, (String)writeValue);
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.colorId, (int)writeColor);
    }

    public String getWriteValue() {
        String value = ValueNotifierHelpers.getValueString((IValueNotifier)this, (int)this.valueId);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public int getWriteValueColor() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.colorId);
    }
}

