/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.modcompat.mcmultipart;

import com.google.common.base.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.client.model.CableModelBase;

public class PartCableModel
extends CableModelBase {
    public PartCableModel(IBlockState blockState, EnumFacing facing, long rand) {
        super(blockState, facing, rand);
    }

    public PartCableModel(ItemStack itemStack, World world, EntityLivingBase entity) {
        super(itemStack, world, entity);
    }

    public PartCableModel() {
    }

    @Override
    protected boolean isRealCable() {
        return true;
    }

    @Override
    protected Optional<IBlockState> getFacade() {
        return Optional.absent();
    }

    @Override
    protected boolean isConnected(EnumFacing side) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)this.getState(), BlockCable.CONNECTED[side.ordinal()], (Object)false);
    }

    @Override
    protected boolean hasPart(EnumFacing side) {
        return this.getPartRenderPosition(side) != IPartType.RenderPosition.NONE;
    }

    @Override
    protected IPartType.RenderPosition getPartRenderPosition(EnumFacing side) {
        return (IPartType.RenderPosition)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)this.getState(), BlockCable.PART_RENDERPOSITIONS[side.ordinal()], (Object)IPartType.RenderPosition.NONE);
    }

    @Override
    protected boolean shouldRenderParts() {
        return false;
    }

    @Override
    protected IBakedModel getPartModel(EnumFacing side) {
        return null;
    }

    public IBakedModel handleBlockState(IBlockState state, EnumFacing side, long rand) {
        return new PartCableModel(state, side, rand);
    }

    public IBakedModel handleItemState(ItemStack stack, World world, EntityLivingBase entity) {
        return new PartCableModel(stack, world, entity);
    }
}

