/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism;

import de.maggicraft.ism.loader.BlockManager;
import de.maggicraft.ism.loader.ItemManager;
import de.maggicraft.ism.loader.MCContainer;
import de.maggicraft.ism.loader.MCLoaderImpl;
import de.maggicraft.ism.manager.VersionHolder;
import de.maggicraft.ism.mapper.BlockStateMapper;
import de.maggicraft.ism.world.logged.ILoggedManagerMC;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod(value="ism")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ISMMain {
    public static final String MOD_ID = "ism";
    public static final String MINECRAFT_VERSION = "1.16.1";
    public static final String ISM_VERSION = "2.7.5";
    private static BlockStateMapper sBlockStateMapper;
    private static ILoggedManagerMC sLoggedManagerMC;

    public ISMMain() {
        MCContainer.setVersionHolder(new VersionHolder(MINECRAFT_VERSION, ISM_VERSION));
        MinecraftForge.EVENT_BUS.register((Object)this);
        MCContainer.setMCLoader(new MCLoaderImpl());
        MCContainer.getMCLoader().initialize();
        sLoggedManagerMC = (ILoggedManagerMC)MCContainer.getLoggedManagerMC();
        sBlockStateMapper = (BlockStateMapper)MCContainer.getBlockStateMapper();
    }

    @SubscribeEvent
    public static void registerBlocks(@NotNull RegistryEvent.Register<Block> pEvent) {
        BlockManager.registerBlocks(pEvent);
    }

    @SubscribeEvent
    public static void registerItemBlocks(@NotNull RegistryEvent.Register<Item> pEvent) {
        ItemManager.registerItems(pEvent);
        BlockManager.registerItemBlocks(pEvent);
    }

    @NotNull
    public static ILoggedManagerMC getLoggedManagerMC() {
        return sLoggedManagerMC;
    }

    @NotNull
    public static BlockStateMapper getBlockStateMapper() {
        return sBlockStateMapper;
    }
}

