/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism;

import de.maggicraft.ism.loader.IMCLoaderServer;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.loader.ISMLoader;
import de.maggicraft.ism.loader.ISMLoaderServer;
import de.maggicraft.mcommons.initialization.MLazy;
import de.maggicraft.mcommons.initialization.MLazyExport;
import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mcommons.util.EOSType;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.schemes.types.MEnvironment;
import de.maggicraft.mthread.MasterThread;
import java.io.File;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import org.jetbrains.annotations.NotNull;

public class ISMStarter {
    public static final MLazy INIT_ENV = new MLazy(() -> MCon.init(new MEnvironment(){

        @Override
        @NotNull
        public String appName() {
            return "ism";
        }

        @Override
        @NotNull
        public File appPath() {
            File parentPath = super.appPath().getParentFile();
            String prefix = CCon.SEP + "mods" + CCon.SEP + "ism-3" + CCon.SEP;
            String mcFolder = EOSType.getOperatingSystem() == EOSType.OS_MAC ? "Minecraft" : ".minecraft";
            return new File(parentPath, mcFolder + prefix);
        }
    }), "environment");

    public static void main(String[] pArguments) throws RemoteException, NotBoundException {
        System.out.println("started ISM");
        ISMStarter.initializeEnvironment();
        int port = Integer.parseInt(pArguments[0]);
        ISMContainer.setRegistry(LocateRegistry.getRegistry(port));
        ISMContainer.setMCLoaderServer((IMCLoaderServer)ISMContainer.getRegistry().lookup("IMCLoaderServer"));
        ISMContainer.setISMLoaderServer(new ISMLoaderServer());
        MLazyExport.export(ISMContainer.getRegistry(), ISMContainer.getISMLoaderServer());
        String name = "initialize ISM-Side";
        MasterThread thread = new MasterThread(name, 12, 5, 0);
        for (MLazy init : ISMLoader.INITS) {
            thread.add(init::initLazy);
        }
        thread.start();
    }

    public static void initializeEnvironment() {
        INIT_ENV.initLazy();
    }
}

