/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.analytics.manager;

import de.maggicraft.ism.analytics.manager.IAnalyticsManager;
import de.maggicraft.ism.analytics.manager.MAnalyticsSettings;
import de.maggicraft.ism.analytics.manager.MAnalyticsUtil;
import de.maggicraft.ism.analytics.trackers.ITrackable;
import de.maggicraft.ism.analytics.trackers.TrackResolution;
import de.maggicraft.ism.analytics.util.EDimension;
import de.maggicraft.ism.analytics.util.EGAType;
import de.maggicraft.ism.analytics.util.EMeasure;
import de.maggicraft.ism.analytics.util.MViewEventStack;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.manalytics.GoogleAnalyticsBuilder;
import de.maggicraft.manalytics.internal.GoogleAnalyticsImpl;
import de.maggicraft.manalytics.request.GoogleAnalyticsRequest;
import de.maggicraft.mcommons.initialization.IInitializable;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.MTuple;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.AbstractQueue;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;

public class MAnalyticsManager
implements IAnalyticsManager,
IInitializable {
    @NotNull
    private static final String JAVA_VERSION = System.getProperty("java.version");
    @NotNull
    private static final String LANG = System.getProperty("user.language");
    @NotNull
    private static final String COUNTRY = System.getProperty("user.country");
    @NotNull
    private final String mTrackingID;
    @NotNull
    private final String mTrackingIDView;
    private final boolean mTestDataView;
    private MViewEventStack mViewEventStack;
    private GoogleAnalyticsImpl mGA;
    private GoogleAnalyticsImpl mGAView;
    private String mScreenSize;
    private String mUserAgent;
    private AbstractQueue<MTuple<GoogleAnalyticsRequest, EMeasure>> mQueued = new ConcurrentLinkedQueue<MTuple<GoogleAnalyticsRequest, EMeasure>>();
    private final TrackResolution mTrackResolution = new TrackResolution();

    public MAnalyticsManager(@NotNull String pTrackingID, @NotNull String pTrackingIDView, boolean pTestDataView) {
        this.mTrackingID = pTrackingID;
        this.mTrackingIDView = pTrackingIDView;
        this.mTestDataView = pTestDataView;
    }

    @NotNull
    public static MAnalyticsManager getStd() {
        String trackingIdView;
        String trackingId;
        boolean testEnvironment = MLangManager.get("testEnv").equals("true");
        if (testEnvironment) {
            trackingId = "UA-81757253-6";
            trackingIdView = "UA-81757253-7";
        } else {
            trackingId = "UA-81757253-8";
            trackingIdView = "UA-81757253-9";
        }
        boolean testDataView = MLangManager.get("testDataView").equals("true");
        return new MAnalyticsManager(trackingId, trackingIdView, testDataView);
    }

    @NotNull
    private static GoogleAnalyticsImpl getAnalytics(@NotNull String pTrackingId) {
        GoogleAnalyticsBuilder builder = new GoogleAnalyticsBuilder();
        builder.withAppName("ism");
        builder.withAppVersion(ISMContainer.getVersionHolder().getCombinedVersion());
        builder.withTrackingId(pTrackingId);
        return (GoogleAnalyticsImpl)builder.build();
    }

    @Override
    public void initialize() {
        this.mGA = MAnalyticsManager.getAnalytics(this.mTrackingID);
        this.mGAView = MAnalyticsManager.getAnalytics(this.mTrackingIDView);
        this.mViewEventStack = new MViewEventStack();
        MAnalyticsSettings.SETTING_CONSENT_GIVEN.registerObserver(pSetting -> this.sendQueued());
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.mScreenSize = screen.width + "x" + screen.height;
        this.mUserAgent = MAnalyticsUtil.userAgent();
    }

    @Override
    public void send(@NotNull ITrackable pTrackable, @NotNull EGAType pGAType) {
        this.send(pTrackable, pGAType, true);
    }

    @Override
    public void send(@NotNull ITrackable pTrackable, @NotNull EGAType pGAType, boolean pAsynchronously) {
        GoogleAnalyticsRequest request = pTrackable.getRequest();
        this.populateRequest(request, pGAType);
        if (((Boolean)MAnalyticsSettings.SETTING_CONSENT_GIVEN.getValue()).booleanValue()) {
            if (pAsynchronously) {
                request.sendAsync();
            } else {
                request.send();
            }
        } else {
            this.mQueued.add(new MTuple<GoogleAnalyticsRequest, EMeasure>(request, pTrackable.getMeasure()));
        }
    }

    private void populateRequest(@NotNull GoogleAnalyticsRequest pRequest, @NotNull EGAType pGAType) {
        pRequest.setExecutor(pGAType == EGAType.TYPE_NORMAL ? this.mGA : this.mGAView);
        pRequest.dataSource("mod");
        pRequest.applicationName("ism");
        pRequest.applicationVersion(ISMContainer.getVersionHolder().getISMVersion());
        pRequest.userLanguage(LANG);
        pRequest.geoid(COUNTRY);
        pRequest.anonymizeIp(true);
        pRequest.screenResolution(this.mScreenSize);
        Optional<Dimension> dim = this.mTrackResolution.getCurDimension();
        dim.ifPresent(pDimension -> pRequest.viewportSize(pDimension.width + "x" + pDimension.height));
        pRequest.userAgent(this.mUserAgent);
        pRequest.customDimension(EDimension.JAVA_VERSION.getUID(), JAVA_VERSION);
        pRequest.customDimension(EDimension.MINECRAFT_VERSION.getUID(), ISMContainer.getVersionHolder().getMinecraftVersion());
        if (this.mTestDataView) {
            pRequest.customDimension(EDimension.DATA_VIEW_TYPE.getUID(), "test");
        }
    }

    private void sendQueued() {
        if (this.mQueued.isEmpty()) {
            return;
        }
        for (MTuple mTuple : this.mQueued) {
            if (!MAnalyticsSettings.isEnabled((EMeasure)mTuple.getB())) continue;
            ((GoogleAnalyticsRequest)mTuple.getA()).send();
        }
        this.mQueued = new ConcurrentLinkedQueue<MTuple<GoogleAnalyticsRequest, EMeasure>>();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MAnalyticsManager{");
        sb.append("mTrackingID='").append(this.mTrackingID).append('\'');
        sb.append(", mTrackingIDView='").append(this.mTrackingIDView).append('\'');
        sb.append(", mTestDataView=").append(this.mTestDataView);
        sb.append(", mViewEventStack=").append(this.mViewEventStack);
        sb.append(", mGA=").append(this.mGA);
        sb.append(", mGAView=").append(this.mGAView);
        sb.append(", mScreenSize='").append(this.mScreenSize).append('\'');
        sb.append(", mUserAgent='").append(this.mUserAgent).append('\'');
        sb.append(", mQueued=").append(this.mQueued);
        sb.append(", mTrackResolution=").append(this.mTrackResolution);
        sb.append('}');
        return sb.toString();
    }

    @NotNull
    public String getScreenSize() {
        return this.mScreenSize;
    }

    @NotNull
    public String getUserAgent() {
        return this.mUserAgent;
    }

    @Override
    @NotNull
    public MViewEventStack getViewEventStack() {
        return this.mViewEventStack;
    }
}

