/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.analytics.manager;

import de.maggicraft.ism.analytics.manager.EAnalyticsPreset;
import de.maggicraft.ism.analytics.manager.EAnalyticsSetting;
import de.maggicraft.ism.analytics.manager.MAnalyticsUtil;
import de.maggicraft.ism.analytics.util.EMeasure;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.mcommons.settings.ISetting;
import de.maggicraft.mcommons.settings.MBooleanSetting;
import de.maggicraft.mcommons.settings.MIntegerSetting;
import de.maggicraft.mcommons.settings.MStorableSettings;
import de.maggicraft.mcommons.settings.MTextSetting;
import de.maggicraft.mioutil.json.IUniqueID;
import java.io.File;
import java.util.EnumMap;
import org.jetbrains.annotations.NotNull;

public final class MAnalyticsSettings {
    @NotNull
    public static final MIntegerSetting SETTING_STARTED;
    @NotNull
    public static final MTextSetting SETTING_LAST_ISM_VERSION;
    @NotNull
    public static final MTextSetting SETTING_LAST_MC_VERSION;
    @NotNull
    public static final MIntegerSetting SETTING_PRESET;
    @NotNull
    public static final MBooleanSetting SETTING_CONSENT_GIVEN;
    @NotNull
    private static final EnumMap<EMeasure, ISetting<Boolean>> SETTING_MAP;
    private static MStorableSettings sAnalyticsSettings;

    public static void init(@NotNull File pFile) {
        sAnalyticsSettings = new MStorableSettings(pFile, SETTING_STARTED, SETTING_LAST_ISM_VERSION, SETTING_LAST_MC_VERSION, SETTING_PRESET, SETTING_CONSENT_GIVEN);
    }

    public static MStorableSettings getAnalyticsSettings() {
        return sAnalyticsSettings;
    }

    public static void setPreset(int pEnabledPreset) {
        SETTING_PRESET.setValue(pEnabledPreset);
        for (EMeasure measure : EMeasure.values()) {
            MAnalyticsSettings.setEnabled(measure, MAnalyticsSettings.isEnabledByPreset(measure.getPreset().getUID(), pEnabledPreset));
        }
    }

    public static boolean isEnabledByPreset(int pPreset, int pEnablePreset) {
        return pPreset <= pEnablePreset;
    }

    public static void setEnabled(@NotNull EMeasure pMeasure, boolean pEnabled) {
        ISetting<Boolean> setting = SETTING_MAP.get(pMeasure);
        if (setting.getValue() != pEnabled) {
            setting.setValue(pEnabled);
            if (MAnalyticsUtil.getTables() != null) {
                MAnalyticsUtil.getTables()[pMeasure.getTable().getUID()].setValueAt(pEnabled, pMeasure.getRow(), 3);
            }
        }
    }

    public static boolean isEnabled(@NotNull EMeasure pMeasure) {
        return SETTING_MAP.get(pMeasure).getValue();
    }

    static {
        SETTING_MAP = new EnumMap(EMeasure.class);
        SETTING_STARTED = new MIntegerSetting((IUniqueID<String>)EAnalyticsSetting.SETTINGS_STARTED, 1);
        SETTING_LAST_ISM_VERSION = new MTextSetting((IUniqueID<String>)EAnalyticsSetting.SETTINGS_LAST_ISM_VERSION, ISMContainer.getVersionHolder().getISMVersion());
        SETTING_LAST_MC_VERSION = new MTextSetting((IUniqueID<String>)EAnalyticsSetting.SETTINGS_LAST_MC_VERSION, ISMContainer.getVersionHolder().getMinecraftVersion());
        SETTING_PRESET = new MIntegerSetting((IUniqueID<String>)EAnalyticsSetting.SETTINGS_PRESET, EAnalyticsPreset.PRESET_NORMAL.getUID());
        SETTING_CONSENT_GIVEN = new MBooleanSetting((IUniqueID<String>)EAnalyticsSetting.SETTINGS_CONSENT_GIVEN, false);
        for (EMeasure value : EMeasure.values()) {
            SETTING_MAP.put(value, new MBooleanSetting((IUniqueID<String>)value, true));
        }
    }
}

