/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.analytics.manager;

import de.maggicraft.ism.analytics.manager.MAnalyticsSettings;
import de.maggicraft.ism.analytics.util.EMeasure;
import de.maggicraft.ism.analytics.util.EURI;
import de.maggicraft.ism.analytics.util.IContentable;
import de.maggicraft.ism.gui.MTrackableDialog;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MCombo;
import de.maggicraft.mgui.comp.MEditor;
import de.maggicraft.mgui.comp.MTable;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.view.MDialog;
import de.maggicraft.mgui.view.util.EWindowSize;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MAnalyticsUtil {
    @NotNull
    public static final int[] TABLE_LEN = new int[]{2, 10, 6, 2};
    @NotNull
    public static final int[] TABLE_IDS = new int[TABLE_LEN.length];
    @NotNull
    public static final EMeasure[][] MEASURES = new EMeasure[TABLE_LEN.length][];
    private static MTable[] sTables;
    private static MCombo sComboPreset;

    private MAnalyticsUtil() {
    }

    @Nullable
    public static MDialog consentDialog() {
        if (((Boolean)MAnalyticsSettings.SETTING_CONSENT_GIVEN.getValue()).booleanValue()) {
            return null;
        }
        return new MTrackableDialog((Frame)ISMContainer.getStrExplorer().getFrame(), EWindowSize.FOUR){
            private MButton mSaveButton;

            @Override
            public void init(@NotNull MDialog pDialog) {
                MEditor editor = new MEditor(MPos.pos(pDialog, "[[m,[[p")).title("psInfo");
                sComboPreset = new MCombo(MPos.pos("V[[p,[]p", editor)).title("psInfo0", "psInfo1", "psInfo2");
                sComboPreset.setSelectedIndex(2 - (Integer)MAnalyticsSettings.SETTING_PRESET.getValue());
                this.mSaveButton = new MButton(MPos.pos(pDialog, "]]p,]]s")).addAction(pEvent -> pDialog.dispose()).title("psInfo");
                pDialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent pEvent) {
                        MAnalyticsSettings.SETTING_CONSENT_GIVEN.setValue(true);
                        MAnalyticsSettings.setPreset(2 - sComboPreset.getSelectedIndex());
                    }

                    @Override
                    public void windowClosed(WindowEvent pEvent) {
                        MAnalyticsSettings.SETTING_CONSENT_GIVEN.setValue(true);
                        MAnalyticsSettings.setPreset(2 - sComboPreset.getSelectedIndex());
                    }
                });
            }

            @Override
            public void afterInit() {
                SwingUtilities.invokeLater(() -> {
                    this.update();
                    this.mSaveButton.requestFocus();
                    this.afterDisplay();
                });
            }

            @Override
            public void dispose() {
                super.dispose();
                MAnalyticsSettings.SETTING_CONSENT_GIVEN.setValue(true);
                MAnalyticsSettings.setPreset(2 - sComboPreset.getSelectedIndex());
            }

            @Override
            @NotNull
            protected String getURI() {
                return (Object)((Object)EURI.DIALOG) + "analytics-notification/";
            }
        }.title("psInfo").visible();
    }

    public static void initMeasures() {
        for (int i = 0; i < MEASURES.length; ++i) {
            MAnalyticsUtil.MEASURES[i] = new EMeasure[TABLE_LEN[i]];
        }
        EMeasure[] eMeasureArray = EMeasure.values();
        int n = eMeasureArray.length;
        for (int i = 0; i < n; ++i) {
            EMeasure value;
            MAnalyticsUtil.MEASURES[value.getTable().getUID().intValue()][value.getRow()] = value = eMeasureArray[i];
        }
    }

    @NotNull
    public static String getUTMUrl(@NotNull String pSubUrl, @NotNull IContentable pUTM) {
        return MAnalyticsUtil.getUTMUrl("https://instant-structures-mod.com/", pSubUrl, pUTM);
    }

    @NotNull
    public static String getUTMUrl(String pWebsite, @NotNull String pSubUrl, @NotNull IContentable pTrackingCode) {
        return pWebsite + pSubUrl + "?utm_source=ism&utm_medium=" + ISMContainer.getVersionHolder().getISMVersion() + "&utm_campaign=" + ISMContainer.getVersionHolder().getCombinedVersion().replace(" ", "%20") + "&utm_term=" + pSubUrl.replace("/", "%2F") + "&utm_content=" + pTrackingCode.getContent();
    }

    public static String userAgent() {
        String osAgent;
        String osName;
        switch (osName = System.getProperty("os.name")) {
            case "Windows 3.11": {
                osAgent = "Win16";
                break;
            }
            case "Windows 95": {
                osAgent = "Windows 95";
                break;
            }
            case "Windows 98": {
                osAgent = "Windows 98";
                break;
            }
            case "Windows 2000": {
                osAgent = "Windows NT 5.0";
                break;
            }
            case "Windows XP": {
                osAgent = "Windows NT 5.1";
                break;
            }
            case "Windows Server 2003": {
                osAgent = "Windows NT 5.2";
                break;
            }
            case "Windows Vista": {
                osAgent = "Windows NT 6.0";
                break;
            }
            case "Windows 7": {
                osAgent = "Windows NT 6.1";
                break;
            }
            case "Windows 8": {
                osAgent = "Windows NT 6.2";
                break;
            }
            case "Windows 10": {
                osAgent = "Windows NT 10.0";
                break;
            }
            case "Windows NT 4.0": {
                osAgent = "Windows NT 4.0";
                break;
            }
            case "Windows ME": {
                osAgent = "Windows ME";
                break;
            }
            case "Open BSD": {
                osAgent = "OpenBSD";
                break;
            }
            case "Sun OS": {
                osAgent = "SunOS";
                break;
            }
            case "Linux": {
                osAgent = "Linux";
                break;
            }
            case "Mac OS": 
            case "Mac OS X": {
                osAgent = "Macintosh";
                break;
            }
            case "QNX": {
                osAgent = "QNX";
                break;
            }
            case "BeOS": {
                osAgent = "BeOS";
                break;
            }
            case "OS/2": {
                osAgent = "OS/2";
                break;
            }
            default: {
                osAgent = "";
                ISMContainer.getLogger().logNoAnalytics("unknown operating system: " + osName);
            }
        }
        return "ISM/" + ISMContainer.getVersionHolder().getISMVersion() + " (" + osAgent + ')';
    }

    public static MTable[] getTables() {
        return sTables;
    }

    public static void setTables(MTable[] pTables) {
        sTables = pTables;
    }

    public static MCombo getComboPreset() {
        return sComboPreset;
    }

    public static void setComboPreset(MCombo pComboPreset) {
        sComboPreset = pComboPreset;
    }
}

