/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.analytics.manager;

import de.maggicraft.ism.analytics.manager.MAnalyticsSettings;
import de.maggicraft.ism.analytics.manager.MAnalyticsUtil;
import de.maggicraft.mgui.comp.MTable;
import de.maggicraft.mgui.schemes.MCon;
import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;

public final class MGuiTableUtil {
    private MGuiTableUtil() {
    }

    public static class MBooleanCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        @NotNull
        private final JCheckBox editor;
        private final JTable mTable;
        private int mRowChanged;

        public MBooleanCellEditor(JTable pTable) {
            this.mTable = pTable;
            this.editor = new JCheckBox();
            MCon.styleSwitcher(this.editor);
            this.editor.setOpaque(true);
            this.editor.setVerticalAlignment(1);
            this.editor.setFont(MCon.fontSwitcher());
            if (this.mTable instanceof MTable) {
                this.editor.addItemListener(pEvent -> {
                    int id = ((MTable)this.mTable).getId();
                    for (int i = 0; i < MAnalyticsUtil.TABLE_IDS.length; ++i) {
                        if (MAnalyticsUtil.TABLE_IDS[i] != id) continue;
                        MAnalyticsSettings.setEnabled(MAnalyticsUtil.MEASURES[i][this.mRowChanged], this.editor.isSelected());
                    }
                    MAnalyticsUtil.getComboPreset().setSelectedIndex(0);
                });
            }
        }

        @Override
        @NotNull
        public Component getTableCellEditorComponent(JTable pTable, Object pValue, boolean pIsSelected, int pRow, int pColumn) {
            this.editor.setBackground(pRow % 2 == 0 ? MCon.colorTableBackgroundEven() : MCon.colorTableBackgroundOdd());
            if (pValue instanceof Boolean) {
                this.mRowChanged = pRow;
                this.editor.setSelected((Boolean)pValue);
            }
            return this.editor;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor.isSelected();
        }
    }
}

