/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.analytics.server;

import de.maggicraft.ism.analytics.server.ETimer;
import de.maggicraft.ism.analytics.server.IActionTracking;
import de.maggicraft.mcommons.timer.Timer;
import java.util.EnumMap;
import org.jetbrains.annotations.NotNull;

public class ActionTracking
implements IActionTracking {
    @NotNull
    private final EnumMap<ETimer, Timer> mTimers = new EnumMap(ETimer.class);
    @NotNull
    private final String mLabel;
    @NotNull
    private final String mFreeText;

    public ActionTracking(@NotNull String pLabel, @NotNull String pFreeText) {
        this.mLabel = pLabel;
        this.mFreeText = pFreeText;
        for (ETimer timer : ETimer.values()) {
            this.mTimers.put(timer, new Timer());
        }
    }

    @Override
    public void startTimer(@NotNull ETimer pTimer) {
        this.mTimers.get(pTimer).startTimer();
    }

    @Override
    public void pauseTimer(@NotNull ETimer pTimer) {
        this.mTimers.get(pTimer).pauseTimer();
    }

    @Override
    public void resumeTimer(@NotNull ETimer pTimer) {
        this.mTimers.get(pTimer).resumeTimer();
    }

    @Override
    public void stopTimer(@NotNull ETimer pTimer) {
        this.mTimers.get(pTimer).stopTimer();
    }

    @Override
    public long getTime(@NotNull ETimer pTimer) {
        return this.mTimers.get(pTimer).getTime();
    }

    @Override
    @NotNull
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    @NotNull
    public String getFreeText() {
        return this.mFreeText;
    }
}

