/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.analytics.server;

import de.maggicraft.ism.analytics.server.EItemTracker;
import de.maggicraft.ism.analytics.server.EItemTrackerLabel;
import de.maggicraft.ism.analytics.server.IActionTracking;
import de.maggicraft.ism.analytics.server.IAnalyticsManagerServer;
import de.maggicraft.ism.analytics.server.IAnalyticsManagerWrapper;
import de.maggicraft.ism.loader.MCContainer;
import de.maggicraft.mcommons.initialization.IInitializable;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import org.jetbrains.annotations.NotNull;

public class AnalyticsManagerWrapper
implements IAnalyticsManagerWrapper,
IInitializable {
    private IAnalyticsManagerServer mAnalyticsManager;

    @Override
    public void initialize() {
        try {
            MCContainer.getISMLoaderServer().requiredAnalyticsManagerServer();
            this.mAnalyticsManager = (IAnalyticsManagerServer)MCContainer.getRegistry().lookup("minecraftAnalytics");
        }
        catch (NotBoundException | RemoteException pE) {
            MCContainer.getLogger().log(pE);
        }
    }

    @Override
    public void trackItem(@NotNull EItemTracker pTracker, @NotNull EItemTrackerLabel pTrackerLabels) {
        try {
            this.mAnalyticsManager.trackItem(pTracker, pTrackerLabels);
        }
        catch (RemoteException pE) {
            MCContainer.getLogger().log(pE);
        }
    }

    @Override
    public void trackScanStructure(@NotNull String pName, @NotNull String pFreeText, int pBlocks, long pTimeTotal, long pTimeRead, long pTimeFormat, long pTimeWrite) {
        try {
            this.mAnalyticsManager.trackScanStructure(pName, pFreeText, pBlocks, pTimeTotal, pTimeRead, pTimeFormat, pTimeWrite);
        }
        catch (RemoteException pE) {
            MCContainer.getLogger().log(pE);
        }
    }

    @Override
    public void trackPlaceStructure(@NotNull IActionTracking pTracking, int pBlocks, int pLights, int pChunks) {
        try {
            this.mAnalyticsManager.trackPlaceStructure(pTracking, pBlocks, pLights, pChunks);
        }
        catch (RemoteException pE) {
            MCContainer.getLogger().log(pE);
        }
    }

    @Override
    public void trackReposStructure(@NotNull IActionTracking pTracking, int pBlocks, int pLights, int pChunks) {
        try {
            this.mAnalyticsManager.trackReposStructure(pTracking, pBlocks, pLights, pChunks);
        }
        catch (RemoteException pE) {
            MCContainer.getLogger().log(pE);
        }
    }

    @Override
    public void trackRemoveStructure(@NotNull IActionTracking pTracking, int pBlocks, int pLights, int pChunks) {
        try {
            this.mAnalyticsManager.trackRemoveStructure(pTracking, pBlocks, pLights, pChunks);
        }
        catch (RemoteException pE) {
            MCContainer.getLogger().log(pE);
        }
    }
}

