/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.analytics.server;

import de.maggicraft.ism.analytics.manager.MAnalyticsSettings;
import de.maggicraft.ism.analytics.server.ECategory;
import de.maggicraft.ism.analytics.server.ETimer;
import de.maggicraft.ism.analytics.server.IActionTracking;
import de.maggicraft.ism.analytics.trackers.TrackingEvent;
import de.maggicraft.ism.analytics.util.EDimension;
import de.maggicraft.ism.analytics.util.EMeasure;
import de.maggicraft.ism.analytics.util.EMetric;
import de.maggicraft.ism.analytics.util.IDimension;
import de.maggicraft.ism.world.place.ITrackedPlaceStructure;
import org.jetbrains.annotations.NotNull;

public class TrackAction
extends TrackingEvent {
    private TrackAction(@NotNull EMeasure pMeasure, @NotNull String pAction, @NotNull IActionTracking pTracking, int pBlocks, int pLights, int pChunks) {
        super(pMeasure, ECategory.CATEGORY_WORLD, pAction, pTracking.getLabel());
        this.dimension((IDimension)EDimension.FREE_TEXT, pTracking.getFreeText());
        this.metric(EMetric.TIME_TOTAL, pTracking.getTime(ETimer.TOTAL));
        this.metric(EMetric.TIME_ONE, pTracking.getTime(ETimer.BLOCKS));
        this.metric(EMetric.TIME_TWO, pTracking.getTime(ETimer.LIGHTEN));
        this.metric(EMetric.TIME_THREE, pTracking.getTime(ETimer.CHUNKS));
        this.metric(EMetric.BLOCKS, pBlocks);
        this.metric(EMetric.LIGHTS, pLights);
        this.metric(EMetric.CHUNKS, pChunks);
        this.gathered();
    }

    private TrackAction(@NotNull EMeasure pMeasure, @NotNull ITrackedPlaceStructure pTracking, @NotNull String pAction, @NotNull String pLabel, @NotNull String pFreeText) {
        super(pMeasure, ECategory.CATEGORY_WORLD, pAction, pLabel);
        this.dimension((IDimension)EDimension.FREE_TEXT, pFreeText);
        this.metric(EMetric.TIME_TOTAL, pTracking.getTotalTime());
        this.metric(EMetric.TIME_ONE, pTracking.getBlocksTime());
        this.metric(EMetric.TIME_TWO, pTracking.getLightsTime());
        this.metric(EMetric.TIME_THREE, pTracking.getChunksTime());
        this.metric(EMetric.BLOCKS, pTracking.getBlocksQuantity());
        this.metric(EMetric.LIGHTS, pTracking.getLightsQuantity());
        this.metric(EMetric.CHUNKS, pTracking.getChunksQuantity());
        this.gathered();
    }

    public static void trackPlaceStructure(@NotNull IActionTracking pTracking, int pBlocks, int pLights, int pChunks) {
        if (MAnalyticsSettings.isEnabled(EMeasure.TRACK_PLACE_STR)) {
            TrackAction trackAction = new TrackAction(EMeasure.TRACK_PLACE_STR, "Place Structure", pTracking, pBlocks, pLights, pChunks);
            trackAction.send();
        }
    }

    public static void trackPlaceStructure(@NotNull ITrackedPlaceStructure pTracked, @NotNull String pLabel, @NotNull String pFreeText) {
        if (MAnalyticsSettings.isEnabled(EMeasure.TRACK_PLACE_STR)) {
            TrackAction trackAction = new TrackAction(EMeasure.TRACK_PLACE_STR, pTracked, "Place Structure", pLabel, pFreeText);
            trackAction.send();
        }
    }

    public static void trackReposStructure(@NotNull IActionTracking pTracking, int pBlocks, int pLights, int pChunks) {
        if (MAnalyticsSettings.isEnabled(EMeasure.TRACK_REPOS_STR)) {
            TrackAction trackAction = new TrackAction(EMeasure.TRACK_REPOS_STR, "Reposition Structure", pTracking, pBlocks, pLights, pChunks);
            trackAction.send();
        }
    }

    public static void trackRemoveStructure(@NotNull IActionTracking pTracking, int pBlocks, int pLights, int pChunks) {
        if (MAnalyticsSettings.isEnabled(EMeasure.TRACK_REMOVE_STR)) {
            TrackAction trackAction = new TrackAction(EMeasure.TRACK_REMOVE_STR, "Remove Structure", pTracking, pBlocks, pLights, pChunks);
            trackAction.send();
        }
    }
}

