/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.analytics.server;

import de.maggicraft.ism.analytics.manager.MAnalyticsSettings;
import de.maggicraft.ism.analytics.server.ECategory;
import de.maggicraft.ism.analytics.server.EItemTracker;
import de.maggicraft.ism.analytics.server.EItemTrackerLabel;
import de.maggicraft.ism.analytics.trackers.TrackingEvent;
import de.maggicraft.ism.analytics.util.EMeasure;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TrackItem
extends TrackingEvent {
    private static final Map<EItemTracker, EMeasure> MAP = new EnumMap<EItemTracker, EMeasure>(EItemTracker.class);

    private TrackItem(@NotNull EItemTracker pItem, @NotNull EItemTrackerLabel pLabel) {
        super(MAP.get(pItem), ECategory.CATEGORY_ITEM, pItem.getName(), pLabel.getName());
        this.gathered();
    }

    public static void trackItem(@NotNull EItemTracker pItem, @NotNull EItemTrackerLabel pLabel) {
        if (MAnalyticsSettings.isEnabled(MAP.get(pItem))) {
            new TrackItem(pItem, pLabel).send();
        }
    }

    static {
        MAP.put(EItemTracker.ITEM_BOUNDING_BOX, EMeasure.TRACK_SCAN_STRUCTURE);
        MAP.put(EItemTracker.BLOCK_GREEN, EMeasure.TRACK_SCAN_STRUCTURE);
        MAP.put(EItemTracker.BLOCK_RED, EMeasure.TRACK_SCAN_STRUCTURE);
        MAP.put(EItemTracker.ITEM_EXPLORER, EMeasure.TRACK_VIEW);
        MAP.put(EItemTracker.ITEM_PLACE, EMeasure.TRACK_PLACE_STR);
        MAP.put(EItemTracker.ITEM_REPOS, EMeasure.TRACK_REPOS_STR);
        MAP.put(EItemTracker.ITEM_REMOVE, EMeasure.TRACK_REMOVE_STR);
        MAP.put(EItemTracker.ITEM_SHAPE, EMeasure.TRACK_SHAPE);
    }
}

